/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.job.app;

import com.helger.base.callback.ICallback;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.commons.deadlock.ThreadDeadlockDetector;
import com.helger.photon.core.interror.callback.MailingThreadDeadlockCallback;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class CheckThreadDeadlockJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckThreadDeadlockJob.class);

    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking for dead locks");
        }
        ThreadDeadlockDetector threadDeadlockDetector = new ThreadDeadlockDetector();
        threadDeadlockDetector.callbacks().add((ICallback)new MailingThreadDeadlockCallback());
        threadDeadlockDetector.findDeadlockedThreads();
    }

    @Nonnull
    public static TriggerKey schedule(@Nonnull SimpleScheduleBuilder simpleScheduleBuilder) {
        ValueEnforcer.notNull((Object)simpleScheduleBuilder, (String)"ScheduleBuilder");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        return GlobalQuartzScheduler.getInstance().scheduleJob(CheckThreadDeadlockJob.class.getName(), JDK8TriggerBuilder.newTrigger().startNow().withSchedule((IScheduleBuilder)simpleScheduleBuilder), CheckThreadDeadlockJob.class, (Map)commonsHashMap);
    }
}

