/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.job.app;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.io.misc.SizeHelper;
import com.helger.photon.core.interror.InternalErrorHandler;
import com.helger.photon.core.interror.InternalErrorSettings;
import com.helger.photon.io.WebFileIO;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.TriggerKey;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class CheckDiskUsableSpaceJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckDiskUsableSpaceJob.class);
    private static final String JOB_DATA_ATTR_THRESHOLD_BYTES = "threshold-bytes";
    private static final String JOB_DATA_ATTR_PATH_SUPPLIER = "path-supplier";
    private static final AtomicInteger JOB_COUNT = new AtomicInteger(0);

    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        long l;
        long l2 = jobDataMap.getAsLong((Object)JOB_DATA_ATTR_THRESHOLD_BYTES);
        Supplier supplier = (Supplier)jobDataMap.getCastedValue((Object)JOB_DATA_ATTR_PATH_SUPPLIER);
        File file = (File)supplier.get();
        String string = file.getAbsolutePath();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking for usable space on '" + string + "' with a threshold of " + l2 + " bytes");
        }
        if ((l = file.getUsableSpace()) <= l2) {
            SizeHelper sizeHelper = SizeHelper.getSizeHelperOfLocale((Locale)Locale.US);
            String string2 = sizeHelper.getAsMatching(l2, 3);
            String string3 = sizeHelper.getAsMatching(l, 3);
            LOGGER.warn("File system of '" + string + "' has less or equal than " + string2 + " of usable space: " + string3);
            String string4 = InternalErrorHandler.fillInternalErrorMetaData(null, "out-of-usable-disk-space", null).addField("base path", string).addField("threshold space", string2).addField("usable space", string3).getAsString();
            EmailData emailData = new EmailData(EEmailType.TEXT);
            emailData.setFrom(InternalErrorSettings.getSMTPSenderAddress());
            emailData.to().addAll(InternalErrorSettings.getSMTPReceiverAddresses());
            emailData.setSubject("[ph-oton] Usable Disk Space on '" + string + "' is low: " + string3);
            emailData.setBody(string4);
            ScopedMailAPI.getInstance().queueMail(InternalErrorSettings.getSMTPSettings(), (IMutableEmailData)emailData);
        }
    }

    @Nonnull
    public static TriggerKey schedule(@Nonnull IScheduleBuilder<? extends ITrigger> iScheduleBuilder, @Nonnegative long l) {
        return CheckDiskUsableSpaceJob.schedule(iScheduleBuilder, l, () -> WebFileIO.getDataIO().getBasePathFile());
    }

    @Nonnull
    public static TriggerKey schedule(@Nonnull IScheduleBuilder<? extends ITrigger> iScheduleBuilder, @Nonnegative long l, @Nonnull Supplier<File> supplier) {
        ValueEnforcer.notNull(iScheduleBuilder, (String)"ScheduleBuilder");
        ValueEnforcer.isGE0((long)l, (String)"ThresholdBytes");
        ValueEnforcer.notNull(supplier, (String)"PathSupplier");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        commonsHashMap.put((Object)JOB_DATA_ATTR_THRESHOLD_BYTES, (Object)l);
        commonsHashMap.put((Object)JOB_DATA_ATTR_PATH_SUPPLIER, supplier);
        return GlobalQuartzScheduler.getInstance().scheduleJob(CheckDiskUsableSpaceJob.class.getName() + JOB_COUNT.incrementAndGet(), JDK8TriggerBuilder.newTrigger().startNow().withSchedule(iScheduleBuilder), CheckDiskUsableSpaceJob.class, (Map)commonsHashMap);
    }
}

