/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror.uihandler;

import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.rt.StackTraceHelper;
import com.helger.css.ECSSUnit;
import com.helger.css.property.CCSSProperties;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.IHCNodeWithChildren;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.forms.HCTextArea;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.sections.HCH1;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.interror.uihandler.IUIInternalErrorHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class UIInternalErrorHandler
implements IUIInternalErrorHandler {
    private final IHCNodeWithChildren<?> m_aParentNode;

    public UIInternalErrorHandler(@Nonnull IHCNodeWithChildren<?> iHCNodeWithChildren) {
        this.m_aParentNode = (IHCNodeWithChildren)ValueEnforcer.notNull(iHCNodeWithChildren, (String)"ParentNode");
    }

    @Nonnull
    public IHCNodeWithChildren<?> getParentNode() {
        return this.m_aParentNode;
    }

    @Override
    public void onInternalError(@Nullable Throwable throwable, @Nonnull String string, @Nonnull Locale locale) {
        this.m_aParentNode.addChild((IHCNode)new HCH1().addChild(EPhotonCoreText.INTERNAL_ERROR_TITLE.getDisplayText(locale)));
        this.m_aParentNode.addChild((IHCNode)new HCDiv().addChildren((Iterable)HCExtHelper.nl2brList((String)EPhotonCoreText.INTERNAL_ERROR_DESCRIPTION.getDisplayTextWithArgs(locale, new Object[]{string}))));
        if (GlobalDebug.isDebugMode() && throwable != null) {
            String string2 = StackTraceHelper.getStackAsString((Throwable)throwable, (boolean)false);
            HCTextArea hCTextArea = (HCTextArea)((HCTextArea)((HCTextArea)((HCTextArea)((HCTextArea)new HCTextArea("callstack").setValue(string2)).setRows(20)).addStyle(CCSSProperties.WIDTH.newValue(ECSSUnit.perc((int)98)))).addStyle(CCSSProperties.FONT_SIZE.newValue(ECSSUnit.pt((int)10)))).addStyle(CCSSProperties.FONT_FAMILY.newValue("Courier New"));
            this.m_aParentNode.addChild((IHCNode)hCTextArea);
        }
    }
}

