/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror.callback;

import com.helger.annotation.Nonempty;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.rt.StackTraceHelper;
import com.helger.commons.deadlock.IThreadDeadlockCallback;
import com.helger.commons.deadlock.ThreadDeadlockInfo;
import com.helger.photon.core.interror.InternalErrorHandler;
import com.helger.photon.core.interror.InternalErrorSettings;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.xml.util.thread.ThreadDescriptor;
import com.helger.xml.util.thread.ThreadDescriptorList;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailingThreadDeadlockCallback
implements IThreadDeadlockCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailingThreadDeadlockCallback.class);

    @Nonnull
    public static String getAsString(@Nonnull ThreadDeadlockInfo threadDeadlockInfo) {
        ValueEnforcer.notNull((Object)threadDeadlockInfo, (String)"TDI");
        StringBuilder stringBuilder = new StringBuilder(threadDeadlockInfo.getThreadInfo().toString());
        StackTraceElement[] stackTraceElementArray = threadDeadlockInfo.getAllStackTraceElements();
        if (stackTraceElementArray != null) {
            stringBuilder.append(StackTraceHelper.getStackAsString((StackTraceElement[])stackTraceElementArray, (boolean)false));
        }
        return stringBuilder.toString();
    }

    public void onDeadlockDetected(@Nonnull @Nonempty ThreadDeadlockInfo[] emailData) {
        LOGGER.warn("Deadlock of " + ArrayHelper.getSize((Object[])emailData) + " threads detected!");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(InternalErrorHandler.fillInternalErrorMetaData(null, null, null).getAsString());
        for (ThreadDeadlockInfo threadDeadlockInfo : emailData) {
            stringBuilder.append('\n').append(MailingThreadDeadlockCallback.getAsString(threadDeadlockInfo));
        }
        stringBuilder.append("\n---------------------------------------------------------------\n").append(ThreadDescriptor.createForCurrentThread(null).getAsString()).append("\n---------------------------------------------------------------\n").append(ThreadDescriptorList.createWithAllThreads().getAsString()).append("\n---------------------------------------------------------------");
        EmailData emailData2 = new EmailData(EEmailType.TEXT);
        emailData2.setFrom(InternalErrorSettings.getSMTPSenderAddress());
        emailData2.to().addAll(InternalErrorSettings.getSMTPReceiverAddresses());
        emailData2.setSubject("[ph-oton] Dead lock of " + ((EmailData)emailData).length + " threads detected");
        emailData2.setBody(stringBuilder.toString());
        ScopedMailAPI.getInstance().queueMail(InternalErrorSettings.getSMTPSettings(), (IMutableEmailData)emailData2);
    }
}

