/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror.callback;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.callback.ICallback;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.map.LRUSet;
import com.helger.dao.AbstractDAO;
import com.helger.dao.IDAOReadExceptionCallback;
import com.helger.dao.IDAOWriteExceptionCallback;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.ajax.AjaxSettings;
import com.helger.photon.ajax.IAjaxInvoker;
import com.helger.photon.ajax.callback.IAjaxExceptionCallback;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.api.APISettings;
import com.helger.photon.api.IAPIExceptionCallback;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.photon.core.interror.InternalErrorHandler;
import com.helger.photon.core.longrun.ILongRunningJob;
import com.helger.quartz.IJob;
import com.helger.schedule.job.AbstractJob;
import com.helger.schedule.job.IJobExceptionCallback;
import com.helger.typeconvert.collection.StringMap;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.requesttrack.ILongRunningRequestCallback;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.RequestTracker;
import com.helger.xservlet.requesttrack.TrackedRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;

public abstract class AbstractErrorCallback
implements IAjaxExceptionCallback,
IAPIExceptionCallback,
IDAOReadExceptionCallback,
IDAOWriteExceptionCallback,
IJobExceptionCallback,
ILongRunningRequestCallback,
IParallelRunningRequestCallback {
    private final ICommonsSet<String> m_aHandledLongRunning = new LRUSet(1000);

    protected abstract void onError(@Nullable Throwable var1, @Nullable IRequestWebScopeWithoutResponse var2, @Nonnull @Nonempty String var3, @Nullable Map<String, String> var4);

    public void onAjaxExecutionException(@Nullable IAjaxInvoker iAjaxInvoker, @Nullable String string, @Nonnull IAjaxExecutor iAjaxExecutor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Exception exception) {
        String string2 = "ajax-error-" + (String)(StringHelper.isNotEmpty((String)string) ? string + "-" : "") + InternalErrorHandler.createNewErrorID();
        this.onError(exception, iRequestWebScopeWithoutResponse, string2, (Map<String, String>)new StringMap().add("ajax-function-name", string));
    }

    public void onAPIExecutionException(@Nullable IAPIInvoker iAPIInvoker, @Nonnull InvokableAPIDescriptor invokableAPIDescriptor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Throwable throwable) {
        String string = "api-error-" + InternalErrorHandler.createNewErrorID() + "-" + invokableAPIDescriptor.getPath();
        this.onError(throwable, iRequestWebScopeWithoutResponse, string, (Map<String, String>)new StringMap().add("api-path", invokableAPIDescriptor.getPath()));
    }

    public void onDAOReadException(@Nonnull Throwable throwable, boolean bl, @Nullable IReadableResource iReadableResource) {
        String string = "DAO " + (bl ? "init" : "read") + " error" + (String)(iReadableResource == null ? "" : " for " + iReadableResource.getPath());
        this.onError(throwable, null, string, (Map<String, String>)new StringMap().add("action", bl ? "init" : "read").add("path", iReadableResource == null ? null : iReadableResource.getPath()));
    }

    public void onDAOWriteException(@Nonnull Throwable throwable, @Nonnull IReadableResource iReadableResource, @Nonnull CharSequence charSequence) {
        String string = "DAO write error for " + iReadableResource.getPath() + " with " + charSequence.length() + " chars";
        this.onError(throwable, null, string, (Map<String, String>)new StringMap().add("action", "write").add("path", iReadableResource.getPath()).add("content", (Object)charSequence));
    }

    public void onScheduledJobException(@Nonnull Throwable throwable, @Nullable String string, @Nonnull IJob iJob) {
        this.onError(throwable, null, "Error executing background job " + string, (Map<String, String>)new StringMap().addIfNotNull("job-class", string).add("job-object", (Object)iJob).add("long-running", iJob instanceof ILongRunningJob));
    }

    public void onLongRunningRequest(@Nonnull @Nonempty String string, @Nonnull IRequestWebScope iRequestWebScope, @Nonnegative long l) {
        if (this.m_aHandledLongRunning.add((Object)string)) {
            this.onError(null, (IRequestWebScopeWithoutResponse)iRequestWebScope, "Long running request.", (Map<String, String>)new StringMap().add("request-id", string).add("millisecconds", l).add("URL", iRequestWebScope.getURLEncoded()));
        }
    }

    public void onParallelRunningRequests(@Nonnegative int n, @Nonnull @Nonempty List<TrackedRequest> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TrackedRequest trackedRequest : list) {
            stringBuilder.append('\n').append(trackedRequest.getRequestScope().getURLEncoded());
        }
        this.onError(null, null, "Currently " + n + " parallel requests are active: " + stringBuilder.toString(), (Map<String, String>)new StringMap().add("parallel-requests", n));
    }

    public void onParallelRunningRequestsBelowLimit() {
    }

    @OverrideOnDemand
    public void install() {
        AbstractErrorCallback.installToPhoton(this);
    }

    public static void installToPhoton(@Nonnull AbstractErrorCallback abstractErrorCallback) {
        AjaxSettings.exceptionCallbacks().add((ICallback)abstractErrorCallback);
        APISettings.exceptionCallbacks().add((ICallback)abstractErrorCallback);
        AbstractDAO.exceptionHandlersRead().add((ICallback)abstractErrorCallback);
        AbstractDAO.exceptionHandlersWrite().add((ICallback)abstractErrorCallback);
        AbstractJob.exceptionCallbacks().add((ICallback)abstractErrorCallback);
        RequestTracker.longRunningRequestCallbacks().add((ICallback)abstractErrorCallback);
        RequestTracker.parallelRunningRequestCallbacks().add((ICallback)abstractErrorCallback);
    }
}

