/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.email.IEmailAddress;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.photon.core.interror.InternalErrorEmailSettings;
import com.helger.photon.core.interror.InternalErrorMetadata;
import com.helger.photon.core.interror.callback.IInternalErrorCallback;
import com.helger.photon.io.WebFileIO;
import com.helger.smtp.settings.ISMTPSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.function.Function;

@ThreadSafe
public final class InternalErrorSettings {
    public static final boolean DEFAULT_ENABLE_FULL_THREAD_DUMPS = false;
    public static final boolean DEFAULT_SEND_EMAIL = true;
    public static final boolean DEFAULT_SAVE_AS_XML = true;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final InternalErrorEmailSettings EMAIL_SETTINGS = new InternalErrorEmailSettings();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bEnableDumpAllThreads = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bSendEmail = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bSaveAsXML = true;
    @GuardedBy(value="RW_LOCK")
    private static Locale s_aFallbackLocale = Locale.US;
    private static final CallbackList<IInternalErrorCallback> CALLBACKS = new CallbackList();
    @GuardedBy(value="RW_LOCK")
    private static Function<InternalErrorMetadata, File> s_aStorageFileProvider;

    private InternalErrorSettings() {
    }

    public static void setSMTPSettings(@Nullable ISMTPSettings iSMTPSettings) {
        RW_LOCK.writeLocked(() -> EMAIL_SETTINGS.setSMTPSettings(iSMTPSettings));
    }

    @Nullable
    public static ISMTPSettings getSMTPSettings() {
        return (ISMTPSettings)RW_LOCK.readLockedGet(EMAIL_SETTINGS::getSMTPSettings);
    }

    public static void setSMTPSenderAddress(@Nullable IEmailAddress iEmailAddress) {
        RW_LOCK.writeLocked(() -> EMAIL_SETTINGS.setSenderAddress(iEmailAddress));
    }

    @Nullable
    public static IEmailAddress getSMTPSenderAddress() {
        return (IEmailAddress)RW_LOCK.readLockedGet(EMAIL_SETTINGS::getSenderAddress);
    }

    public static void setSMTPReceiverAddress(@Nullable IEmailAddress iEmailAddress) {
        RW_LOCK.writeLocked(() -> EMAIL_SETTINGS.setReceiverAddress(iEmailAddress));
    }

    public static void setSMTPReceiverAddresses(@Nullable Iterable<? extends IEmailAddress> iterable) {
        RW_LOCK.writeLocked(() -> EMAIL_SETTINGS.setReceiverAddresses(iterable));
    }

    public static void setSMTPReceiverAddresses(IEmailAddress ... iEmailAddressArray) {
        RW_LOCK.writeLocked(() -> EMAIL_SETTINGS.setReceiverAddresses(iEmailAddressArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IEmailAddress> getSMTPReceiverAddresses() {
        return (ICommonsList)RW_LOCK.readLockedGet(EMAIL_SETTINGS::getAllReceiverAddresses);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static InternalErrorEmailSettings getCopyOfEmailSettings() {
        return (InternalErrorEmailSettings)RW_LOCK.readLockedGet(EMAIL_SETTINGS::getClone);
    }

    public static void setDumpAllThreads(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bEnableDumpAllThreads = bl;
        });
    }

    public static boolean isDumpAllThreads() {
        return RW_LOCK.readLockedBoolean(() -> s_bEnableDumpAllThreads);
    }

    public static void setSendEmail(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bSendEmail = bl;
        });
    }

    public static boolean isSendEmail() {
        return RW_LOCK.readLockedBoolean(() -> s_bSendEmail);
    }

    public static void setSaveAsXML(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bSaveAsXML = bl;
        });
    }

    public static boolean isSaveAsXML() {
        return RW_LOCK.readLockedBoolean(() -> s_bSaveAsXML);
    }

    @Nonnull
    public static Locale getFallbackLocale() {
        return (Locale)RW_LOCK.readLockedGet(() -> s_aFallbackLocale);
    }

    public static void setFallbackLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"FallbackLocale");
        RW_LOCK.writeLocked(() -> {
            s_aFallbackLocale = locale;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IInternalErrorCallback> callbacks() {
        return CALLBACKS;
    }

    @Nonnull
    public static Function<InternalErrorMetadata, File> getStorageFileProvider() {
        return (Function)RW_LOCK.readLockedGet(() -> s_aStorageFileProvider);
    }

    public static void setStorageFileProvider(@Nonnull Function<InternalErrorMetadata, File> function) {
        ValueEnforcer.notNull(function, (String)"StorageFileProvider");
        RW_LOCK.writeLocked(() -> {
            s_aStorageFileProvider = function;
        });
    }

    public static void setDefaultStorageFileProvider() {
        InternalErrorSettings.setStorageFileProvider(internalErrorMetadata -> {
            LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
            String string = StringHelper.getConcatenatedOnDemand((String)PDTIOHelper.getLocalDateTimeForFilename((LocalDateTime)localDateTime), (String)"-", (String)internalErrorMetadata.getErrorID()) + ".xml";
            return WebFileIO.getDataIO().getFile("internal-errors/" + localDateTime.getYear() + "/" + StringHelper.getLeadingZero((int)localDateTime.getMonthValue(), (int)2) + "/" + StringHelper.getLeadingZero((int)localDateTime.getDayOfMonth(), (int)2) + "/" + string);
        });
    }

    @Deprecated(forRemoval=false)
    public static void setDefaultStorageFileProviderUpTo921() {
        InternalErrorSettings.setStorageFileProvider(internalErrorMetadata -> {
            LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
            String string = StringHelper.getConcatenatedOnDemand((String)PDTIOHelper.getLocalDateTimeForFilename((LocalDateTime)localDateTime), (String)"-", (String)internalErrorMetadata.getErrorID()) + ".xml";
            return WebFileIO.getDataIO().getFile("internal-errors/" + localDateTime.getYear() + "/" + StringHelper.getLeadingZero((int)localDateTime.getMonthValue(), (int)2) + "/" + string);
        });
    }

    @Deprecated(forRemoval=false)
    public static void setDefaultStorageFileProviderUpTo802() {
        InternalErrorSettings.setStorageFileProvider(internalErrorMetadata -> {
            LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
            String string = StringHelper.getConcatenatedOnDemand((String)PDTIOHelper.getLocalDateTimeForFilename((LocalDateTime)localDateTime), (String)"-", (String)internalErrorMetadata.getErrorID()) + ".xml";
            return WebFileIO.getDataIO().getFile("internal-errors/" + localDateTime.getYear() + "/" + string);
        });
    }

    static {
        InternalErrorSettings.setDefaultStorageFileProvider();
    }
}

