/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.microdom.IHasMicroNodeRepresentation;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class InternalErrorMetadata
implements IHasMicroNodeRepresentation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalErrorMetadata.class);
    private final String m_sErrorID;
    private final ICommonsList<Entry> m_aFields = new CommonsArrayList();
    private final ICommonsList<Entry> m_aRequestFields = new CommonsArrayList();
    private final ICommonsList<Entry> m_aRequestHeaders = new CommonsArrayList();
    private final ICommonsList<Entry> m_aRequestParameters = new CommonsArrayList();
    private final ICommonsList<Entry> m_aRequestCookies = new CommonsArrayList();
    private final ICommonsList<Entry> m_aSessionFields = new CommonsArrayList();

    public InternalErrorMetadata(@Nullable String string) {
        this.m_sErrorID = string;
    }

    @Nullable
    public String getErrorID() {
        return this.m_sErrorID;
    }

    @Nonnull
    public InternalErrorMetadata addField(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aFields.add((Object)new Entry(string, string2));
        return this;
    }

    @Nonnull
    public InternalErrorMetadata addFieldRetrievalError(@Nonnull @Nonempty String string, @Nonnull Throwable throwable) {
        String string2 = "Failed to get " + string + ": " + throwable.getMessage() + " -- " + throwable.getClass().getName();
        LOGGER.warn(string2);
        return this.addField(string, string2);
    }

    @Nullable
    public String getFieldValue(@Nullable String string, @Nullable String string2) {
        Entry entry2 = StringHelper.isEmpty((String)string) ? null : (Entry)this.m_aFields.findFirst(entry -> entry.getKey().equals(string));
        return entry2 != null ? entry2.getValue() : string2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllFields() {
        return (ICommonsList)this.m_aFields.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addRequestField(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aRequestFields.add((Object)new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllRequestFields() {
        return (ICommonsList)this.m_aRequestFields.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addRequestHeader(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aRequestHeaders.add((Object)new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllRequestHeaders() {
        return (ICommonsList)this.m_aRequestHeaders.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addRequestParameter(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aRequestParameters.add((Object)new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllRequestParameters() {
        return (ICommonsList)this.m_aRequestParameters.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addRequestCookie(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aRequestCookies.add((Object)new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllRequestCookies() {
        return (ICommonsList)this.m_aRequestCookies.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addSessionField(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aSessionFields.add((Object)new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllSessionFields() {
        return (ICommonsList)this.m_aSessionFields.getClone();
    }

    @Nonnull
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this.m_aFields) {
            stringBuilder.append(entry.getAsString()).append('\n');
        }
        if (!this.m_aRequestFields.isEmpty()) {
            stringBuilder.append("Request:\n");
            for (Entry entry : this.m_aRequestFields) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        if (!this.m_aRequestHeaders.isEmpty()) {
            stringBuilder.append("Request header:\n");
            for (Entry entry : this.m_aRequestHeaders) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        if (!this.m_aRequestParameters.isEmpty()) {
            stringBuilder.append("Request parameters:\n");
            for (Entry entry : this.m_aRequestParameters) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        if (!this.m_aRequestCookies.isEmpty()) {
            stringBuilder.append("Request cookies:\n");
            for (Entry entry : this.m_aRequestCookies) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        if (!this.m_aSessionFields.isEmpty()) {
            stringBuilder.append("Session field:\n");
            for (Entry entry : this.m_aSessionFields) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public IMicroElement getAsMicroNode() {
        MicroElement microElement = new MicroElement("metadata");
        microElement.setAttribute("errorid", this.m_sErrorID);
        IMicroElement iMicroElement = microElement.addElement("fields");
        for (Entry entry : this.m_aFields) {
            iMicroElement.addChild((IMicroNode)entry.getAsMicroNode());
        }
        if (!this.m_aRequestFields.isEmpty()) {
            iMicroElement = microElement.addElement("requestfields");
            for (Entry entry : this.m_aRequestFields) {
                iMicroElement.addChild((IMicroNode)entry.getAsMicroNode());
            }
        }
        if (!this.m_aRequestHeaders.isEmpty()) {
            iMicroElement = microElement.addElement("requestheaders");
            for (Entry entry : this.m_aRequestHeaders) {
                iMicroElement.addChild((IMicroNode)entry.getAsMicroNode());
            }
        }
        if (!this.m_aRequestParameters.isEmpty()) {
            iMicroElement = microElement.addElement("requestparameters");
            for (Entry entry : this.m_aRequestParameters) {
                iMicroElement.addChild((IMicroNode)entry.getAsMicroNode());
            }
        }
        if (!this.m_aRequestCookies.isEmpty()) {
            iMicroElement = microElement.addElement("requestcookies");
            for (Entry entry : this.m_aRequestCookies) {
                iMicroElement.addChild((IMicroNode)entry.getAsMicroNode());
            }
        }
        if (!this.m_aSessionFields.isEmpty()) {
            iMicroElement = microElement.addElement("sessionfields");
            for (Entry entry : this.m_aSessionFields) {
                iMicroElement.addChild((IMicroNode)entry.getAsMicroNode());
            }
        }
        return microElement;
    }

    @Immutable
    public static final class Entry
    implements IHasMicroNodeRepresentation {
        private final String m_sKey;
        private final String m_sValue;

        public Entry(@Nonnull @Nonempty String string, @Nullable String string2) {
            this.m_sKey = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
            this.m_sValue = string2;
        }

        @Nonnull
        @Nonempty
        public String getKey() {
            return this.m_sKey;
        }

        @Nullable
        public String getValue() {
            return this.m_sValue;
        }

        @Nonnull
        @Nonempty
        public String getAsString() {
            return this.m_sKey + ": " + this.m_sValue;
        }

        @Nonnull
        public IMicroElement getAsMicroNode() {
            MicroElement microElement = new MicroElement("entry");
            microElement.setAttribute("key", this.m_sKey);
            microElement.addText((CharSequence)this.m_sValue);
            return microElement;
        }
    }
}

