/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.codec.base64.Base64;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.email.IEmailAddress;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.lang.ClassPathHelper;
import com.helger.base.numeric.mutable.MutableInt;
import com.helger.base.rt.StackTraceHelper;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.web.PDTWebDateHelper;
import com.helger.photon.core.appid.RequestSettings;
import com.helger.photon.core.interror.InternalErrorEmailSettings;
import com.helger.photon.core.interror.InternalErrorMetadata;
import com.helger.photon.core.interror.InternalErrorSettings;
import com.helger.photon.core.interror.uihandler.IUIInternalErrorHandler;
import com.helger.scope.mgr.ScopeSessionManager;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.request.RequestLogger;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IEmailAttachmentDataSource;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailAPI;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.ISessionWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.util.thread.ThreadDescriptor;
import com.helger.xml.util.thread.ThreadDescriptorList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class InternalErrorHandler {
    public static final boolean DEFAULT_ENABLE_FULL_THREAD_DUMPS = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalErrorHandler.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, MutableInt> INT_ERR_CACHE = new CommonsHashMap();

    private InternalErrorHandler() {
    }

    @Nonnull
    @Nonempty
    public static String createNewErrorID() {
        try {
            return Integer.toString(GlobalIDFactory.getNewPersistentIntID());
        }
        catch (IllegalStateException illegalStateException) {
            return "t" + GlobalIDFactory.getNewIntID() + "_" + System.currentTimeMillis();
        }
    }

    @Nonnull
    @Nonempty
    public static String createNewInternalErrorID() {
        return "internal-error-" + InternalErrorHandler.createNewErrorID();
    }

    @Nonnull
    @Nonempty
    private static String _getThrowableAsString(@Nonnull Throwable throwable) {
        return throwable.getMessage() + " -- " + throwable.getClass().getName();
    }

    @Nonnull
    private static String _createMailSubject(@Nonnull InternalErrorMetadata internalErrorMetadata) {
        StringBuilder stringBuilder = new StringBuilder();
        if (GlobalDebug.isDebugMode()) {
            stringBuilder.append("[DEBUG] ");
        }
        if (GlobalDebug.isProductionMode()) {
            stringBuilder.append("[PRODUCTION] ");
        }
        stringBuilder.append("Internal error");
        String string = internalErrorMetadata.getFieldValue("Error Message", null);
        if (StringHelper.isNotEmpty((String)string)) {
            stringBuilder.append(": ").append(string);
        }
        stringBuilder.append(" [").append(internalErrorMetadata.getErrorID()).append(']');
        return stringBuilder.toString();
    }

    private static void _sendInternalErrorMailToVendor(@Nonnull InternalErrorMetadata internalErrorMetadata, @Nonnull ThreadDescriptor threadDescriptor, @Nullable ThreadDescriptorList threadDescriptorList, @Nonnull InternalErrorEmailSettings internalErrorEmailSettings, @Nullable IEmailAttachmentList iEmailAttachmentList, boolean bl, @Nonnegative int n) {
        block14: {
            IEmailAddress iEmailAddress;
            int n2 = 1;
            String string = threadDescriptor.getStackTrace();
            if (StringHelper.isNotEmpty((String)string) && n > 1) {
                iEmailAddress = (MutableInt)RW_LOCK.writeLockedGet(() -> (MutableInt)INT_ERR_CACHE.computeIfAbsent((Object)string, string -> new MutableInt(-1)));
                iEmailAddress.inc();
                n2 = iEmailAddress.intValue();
                if (n2 % n != 0) {
                    LOGGER.warn("Not sending internal error mail, because this error occurred " + n2 + " times");
                    return;
                }
            }
            iEmailAddress = internalErrorEmailSettings.getSenderAddress();
            ICommonsList<IEmailAddress> iCommonsList = internalErrorEmailSettings.getAllReceiverAddresses();
            ISMTPSettings iSMTPSettings = internalErrorEmailSettings.getSMTPSettings();
            boolean bl2 = true;
            if (iEmailAddress == null) {
                LOGGER.warn("Not sending internal error mail, because 'sender' is not set!");
                bl2 = false;
            } else if (iCommonsList.isEmpty()) {
                LOGGER.warn("Not sending internal error mail, because 'receiver' is not set!");
                bl2 = false;
            } else if (iSMTPSettings == null) {
                LOGGER.warn("Not sending internal error mail, because 'SMTP settings' is not set!");
                bl2 = false;
            }
            if (bl2) {
                StringBuilder stringBuilder;
                String string2 = InternalErrorHandler._createMailSubject(internalErrorMetadata);
                StringBuilder stringBuilder2 = new StringBuilder().append(internalErrorMetadata.getAsString()).append("\n---------------------------------------------------------------\n").append(threadDescriptor.getAsString()).append("\n---------------------------------------------------------------\n");
                if (threadDescriptorList != null) {
                    stringBuilder2.append(threadDescriptorList.getAsString()).append("\n---------------------------------------------------------------\n");
                }
                if (bl) {
                    stringBuilder = new StringBuilder("ClassPath:\n");
                    for (String string3 : ClassPathHelper.getAllClassPathEntries()) {
                        stringBuilder.append("  ").append(string3).append('\n');
                    }
                    stringBuilder.append("\n---------------------------------------------------------------\n");
                    stringBuilder2.append(stringBuilder.toString());
                }
                stringBuilder = new EmailData(EEmailType.TEXT);
                stringBuilder.setFrom(iEmailAddress);
                stringBuilder.to().addAll(iCommonsList);
                stringBuilder.setSubject(string2);
                stringBuilder.setBody(stringBuilder2.toString());
                stringBuilder.setAttachments(iEmailAttachmentList);
                try {
                    if (ScopedMailAPI.getInstance().queueMail(iSMTPSettings, (IMutableEmailData)stringBuilder).isFailure()) {
                        LOGGER.warn("Failed to send via ScopedMailAPI");
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to send via ScopedMailAPI: " + InternalErrorHandler._getThrowableAsString(exception));
                    if (!MailAPI.queueMail((ISMTPSettings)iSMTPSettings, (IMutableEmailData)stringBuilder).isFailure()) break block14;
                    LOGGER.warn("Failed to send via MailAPI as well");
                }
            }
        }
    }

    @Nonnull
    private static ESuccess _saveInternalErrorToXML(@Nonnull InternalErrorMetadata internalErrorMetadata, @Nonnull ThreadDescriptor threadDescriptor, @Nullable ThreadDescriptorList threadDescriptorList, @Nullable IEmailAttachmentList iEmailAttachmentList) {
        Object object;
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement("internalerror");
        iMicroElement.addChild((IMicroNode)internalErrorMetadata.getAsMicroNode());
        iMicroElement.addChild((IMicroNode)threadDescriptor.getAsMicroNode());
        if (threadDescriptorList != null) {
            iMicroElement.addChild((IMicroNode)threadDescriptorList.getAsMicroNode());
        }
        if (iEmailAttachmentList != null && (object = iEmailAttachmentList.getAsDataSourceList()).isNotEmpty()) {
            IMicroElement iMicroElement2 = iMicroElement.addElement("attachments");
            for (IEmailAttachmentDataSource iEmailAttachmentDataSource : object) {
                IMicroElement iMicroElement3 = iMicroElement2.addElement("attachment");
                iMicroElement3.setAttribute("name", iEmailAttachmentDataSource.getName());
                iMicroElement3.setAttribute("contenttype", iEmailAttachmentDataSource.getContentType());
                try {
                    iMicroElement3.addText((CharSequence)Base64.encodeBytes((byte[])StreamHelper.getAllBytes((InputStream)iEmailAttachmentDataSource.getInputStream())));
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to get content of attachment '" + iEmailAttachmentDataSource.getName() + "'", (Throwable)exception);
                    iMicroElement3.setAttribute("contentsavefailure", "true");
                }
            }
        }
        if ((object = InternalErrorSettings.getStorageFileProvider().apply(internalErrorMetadata)) == null) {
            LOGGER.warn("The File provider returned null - not storing internal error as XML");
            return ESuccess.FAILURE;
        }
        return MicroWriter.writeToFile((IMicroNode)microDocument, (File)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static InternalErrorMetadata fillInternalErrorMetaData(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nullable String string, @Nullable Map<String, String> map) {
        Iterator iterator;
        Object object;
        InternalErrorMetadata internalErrorMetadata = new InternalErrorMetadata(string);
        try {
            internalErrorMetadata.addField("UTCTime", PDTWebDateHelper.getAsStringXSD((ZonedDateTime)ZonedDateTime.now(Clock.systemUTC())));
            internalErrorMetadata.addField("ZonedDateTime", PDTWebDateHelper.getAsStringXSD((ZonedDateTime)PDTFactory.getCurrentZonedDateTime()));
            internalErrorMetadata.addField("LocalDateTime", PDTWebDateHelper.getAsStringXSD((LocalDateTime)PDTFactory.getCurrentLocalDateTime()));
            internalErrorMetadata.addField("CurrentTimeMillis", Long.toString(System.currentTimeMillis()));
        }
        catch (Exception exception) {
            internalErrorMetadata.addField("Time", "System.currentTimeMillis=" + Long.toString(System.currentTimeMillis()));
        }
        if (map != null) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                iterator = (Map.Entry)object.next();
                internalErrorMetadata.addField("[Custom] " + (String)iterator.getKey(), (String)iterator.getValue());
            }
        }
        if ((object = iRequestWebScopeWithoutResponse) == null) {
            try {
                object = WebScopeManager.getRequestScope();
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to get request scope: " + InternalErrorHandler._getThrowableAsString(exception));
            }
        }
        if (object != null) {
            if (!object.isValid()) {
                internalErrorMetadata.addField("Request scope", "!!!Present but invalid!!!");
            }
            try {
                internalErrorMetadata.addField("Request URL", object.getURLEncoded());
            }
            catch (Exception exception) {
                internalErrorMetadata.addFieldRetrievalError("Request URL", exception);
            }
            try {
                internalErrorMetadata.addField("Remote IP address", object.getRemoteAddr());
            }
            catch (Exception exception) {
                internalErrorMetadata.addFieldRetrievalError("Remote IP address", exception);
            }
            for (Cookie[] cookieArray : object.attrs().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
                internalErrorMetadata.addField("[Request Attr] " + (String)cookieArray.getKey(), String.valueOf(cookieArray.getValue()));
            }
            for (Cookie[] cookieArray : object.params().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
                internalErrorMetadata.addField("[Request Param] " + (String)cookieArray.getKey(), String.valueOf(cookieArray.getValue()));
            }
        } else {
            internalErrorMetadata.addField("Request scope", "!!!Not present!!!");
        }
        iterator = null;
        if (object != null) {
            try {
                iterator = (ISessionWebScope)ScopeSessionManager.getInstance().getSessionScopeOfID(object.getSessionID());
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to get session scope from request scope: " + InternalErrorHandler._getThrowableAsString(exception));
            }
        }
        if (iterator == null) {
            try {
                iterator = WebScopeManager.getSessionScope((boolean)false);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to get request scope: " + InternalErrorHandler._getThrowableAsString(exception));
            }
        }
        if (iterator != null) {
            internalErrorMetadata.addField("SessionID", iterator.getID());
            for (Cookie[] cookieArray : iterator.attrs().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
                internalErrorMetadata.addField("[Session] " + (String)cookieArray.getKey(), String.valueOf(cookieArray.getValue()));
            }
        }
        try {
            iterator = InetAddress.getLocalHost();
            internalErrorMetadata.addField("My host name", ((InetAddress)((Object)iterator)).getHostName());
            internalErrorMetadata.addField("My IP address", ((InetAddress)((Object)iterator)).getHostAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            iterator = object.getRequest();
            try {
                for (Cookie[] cookieArray : RequestLogger.getRequestFieldMap((HttpServletRequest)iterator).entrySet()) {
                    internalErrorMetadata.addRequestField((String)cookieArray.getKey(), (String)cookieArray.getValue());
                }
            }
            catch (Exception exception) {
                LOGGER.error("Failed to get request fields from " + String.valueOf(iterator), (Throwable)exception);
            }
            try {
                RequestHelper.getRequestHeaderMap(iterator).forEachSingleHeader(internalErrorMetadata::addRequestHeader, true);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to get request headers from " + String.valueOf(iterator), (Throwable)exception);
            }
            try {
                for (Cookie[] cookieArray : RequestLogger.getRequestParameterMap(iterator).entrySet()) {
                    internalErrorMetadata.addRequestParameter((String)cookieArray.getKey(), (String)cookieArray.getValue());
                }
            }
            catch (Exception exception) {
                LOGGER.error("Failed to get request parameters from " + String.valueOf(iterator), (Throwable)exception);
            }
            try {
                Cookie[] cookieArray;
                cookieArray = ServletHelper.getRequestCookies(iterator);
                if (cookieArray == null) return internalErrorMetadata;
                for (Cookie cookie : cookieArray) {
                    internalErrorMetadata.addRequestCookie(cookie.getName(), cookie.getValue());
                }
                return internalErrorMetadata;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to get request cookies from " + String.valueOf(iterator), (Throwable)exception);
                return internalErrorMetadata;
            }
        }
        internalErrorMetadata.addField("HttpServletRequest", "RequestScope does not contain an HttpServletRequest");
        return internalErrorMetadata;
    }

    private static void _notifyVendorOnInternalError(boolean bl, boolean bl2, @Nullable Throwable throwable, @Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nullable String string, @Nullable Map<String, String> map, @Nonnull InternalErrorEmailSettings internalErrorEmailSettings, @Nullable IEmailAttachmentList iEmailAttachmentList, boolean bl3, @Nonnegative int n) {
        InternalErrorMetadata internalErrorMetadata = InternalErrorHandler.fillInternalErrorMetaData(iRequestWebScopeWithoutResponse, string, map);
        ThreadDescriptor threadDescriptor = ThreadDescriptor.createForCurrentThread((Throwable)throwable);
        ThreadDescriptorList threadDescriptorList = null;
        if (InternalErrorSettings.isDumpAllThreads()) {
            threadDescriptorList = ThreadDescriptorList.createWithAllThreads();
        }
        if (bl) {
            InternalErrorHandler._sendInternalErrorMailToVendor(internalErrorMetadata, threadDescriptor, threadDescriptorList, internalErrorEmailSettings, iEmailAttachmentList, bl3, n);
        }
        if (bl2) {
            InternalErrorHandler._saveInternalErrorToXML(internalErrorMetadata, threadDescriptor, threadDescriptorList, iEmailAttachmentList);
        }
    }

    @Nullable
    private static Locale _getSafeDisplayLocale() {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScopeOrNull();
        if (iRequestWebScope != null) {
            try {
                return RequestSettings.getDisplayLocale((IRequestWebScopeWithoutResponse)iRequestWebScope);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return InternalErrorSettings.getFallbackLocale();
    }

    @Nonnull
    @Nonempty
    static String handleInternalError(boolean bl, boolean bl2, @Nullable IUIInternalErrorHandler iUIInternalErrorHandler, @Nullable Throwable throwable, @Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nullable Map<String, String> map, @Nullable IEmailAttachmentList iEmailAttachmentList, @Nullable Locale locale, boolean bl3, boolean bl4, @Nonnegative int n, @Nullable InternalErrorEmailSettings internalErrorEmailSettings) {
        Locale locale2 = locale != null ? locale : InternalErrorHandler._getSafeDisplayLocale();
        String string = InternalErrorHandler.createNewInternalErrorID();
        LOGGER.error("handleInternalError " + string, throwable);
        if (iUIInternalErrorHandler != null) {
            iUIInternalErrorHandler.onInternalError(throwable, string, locale2);
        }
        if (GlobalDebug.isDebugMode()) {
            if (map != null) {
                LOGGER.error("Custom data: " + String.valueOf(map));
            }
            if (throwable != null && StackTraceHelper.containsUnitTestElement((StackTraceElement[])throwable.getStackTrace())) {
                throw new IllegalStateException("Error executing unit test", throwable);
            }
        } else {
            InternalErrorHandler._notifyVendorOnInternalError(bl, bl2, throwable, iRequestWebScopeWithoutResponse, string, map, internalErrorEmailSettings != null ? internalErrorEmailSettings : InternalErrorSettings.getCopyOfEmailSettings(), iEmailAttachmentList, bl4, n);
        }
        if (bl3) {
            InternalErrorSettings.callbacks().forEach(iInternalErrorCallback -> iInternalErrorCallback.onInternalError(throwable, iRequestWebScopeWithoutResponse, string, locale2));
        }
        return string;
    }
}

