/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.clone.ICloneable;
import com.helger.base.email.IEmailAddress;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.smtp.settings.ISMTPSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public final class InternalErrorEmailSettings
implements ICloneable<InternalErrorEmailSettings> {
    private ISMTPSettings m_aSMTPSettings;
    private IEmailAddress m_aSenderAddress;
    private final ICommonsList<IEmailAddress> m_aReceiverAddresses = new CommonsArrayList();

    public InternalErrorEmailSettings() {
    }

    public InternalErrorEmailSettings(@Nonnull InternalErrorEmailSettings internalErrorEmailSettings) {
        ValueEnforcer.notNull((Object)internalErrorEmailSettings, (String)"Other");
        this.m_aSMTPSettings = internalErrorEmailSettings.m_aSMTPSettings;
        this.m_aSenderAddress = internalErrorEmailSettings.m_aSenderAddress;
        this.m_aReceiverAddresses.setAll(internalErrorEmailSettings.m_aReceiverAddresses);
    }

    @Nonnull
    public InternalErrorEmailSettings setSMTPSettings(@Nullable ISMTPSettings iSMTPSettings) {
        this.m_aSMTPSettings = iSMTPSettings;
        return this;
    }

    @Nullable
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSMTPSettings;
    }

    @Nonnull
    public InternalErrorEmailSettings setSenderAddress(@Nullable IEmailAddress iEmailAddress) {
        this.m_aSenderAddress = iEmailAddress;
        return this;
    }

    @Nullable
    public IEmailAddress getSenderAddress() {
        return this.m_aSenderAddress;
    }

    @Nonnull
    public InternalErrorEmailSettings setReceiverAddress(@Nullable IEmailAddress iEmailAddress) {
        return this.setReceiverAddresses((Iterable<? extends IEmailAddress>)(iEmailAddress == null ? null : new CommonsArrayList((Object)iEmailAddress)));
    }

    @Nonnull
    public InternalErrorEmailSettings setReceiverAddresses(@Nullable Iterable<? extends IEmailAddress> iterable) {
        if (iterable != null && CollectionFind.containsAnyNullElement(iterable)) {
            throw new IllegalArgumentException("The list of receiver addresses may not contain any null element!");
        }
        this.m_aReceiverAddresses.setAll(iterable);
        return this;
    }

    @Nonnull
    public InternalErrorEmailSettings setReceiverAddresses(IEmailAddress ... iEmailAddressArray) {
        if (iEmailAddressArray != null && ArrayHelper.containsAnyNullElement((Object[])iEmailAddressArray)) {
            throw new IllegalArgumentException("The array of receiver addresses may not contain any null element!");
        }
        this.m_aReceiverAddresses.setAll((Object[])iEmailAddressArray);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IEmailAddress> getAllReceiverAddresses() {
        return (ICommonsList)this.m_aReceiverAddresses.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public InternalErrorEmailSettings getClone() {
        return new InternalErrorEmailSettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SMTPSettings", (Object)this.m_aSMTPSettings).append("SenderAddress", (Object)this.m_aSenderAddress).append("ReceiverAddresses", this.m_aReceiverAddresses).getToString();
    }
}

