/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.hc.IHCNodeWithChildren;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.interror.InternalErrorEmailSettings;
import com.helger.photon.core.interror.InternalErrorHandler;
import com.helger.photon.core.interror.InternalErrorSettings;
import com.helger.photon.core.interror.uihandler.IUIInternalErrorHandler;
import com.helger.photon.core.interror.uihandler.UIInternalErrorHandler;
import com.helger.photon.io.WebFileIO;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.smtp.data.EmailAttachmentList;
import com.helger.smtp.data.IEmailAttachment;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;

@NotThreadSafe
public class InternalErrorBuilder {
    public static final boolean DEFAULT_ADD_CLASS_PATH = false;
    public static final boolean DEFAULT_INVOKE_CUSTOM_EXCEPTION_HANDLER = true;
    public static final int DEFAULT_DUPLICATE_ELIMINIATION_COUNTER = 100;
    public static final String KEY_ERROR_MSG = "Error Message";
    protected boolean m_bSendEmail = InternalErrorSettings.isSendEmail();
    protected boolean m_bSaveAsXML = InternalErrorSettings.isSaveAsXML();
    protected IUIInternalErrorHandler m_aUIErrorHandler;
    protected Throwable m_aThrowable;
    protected IRequestWebScopeWithoutResponse m_aRequestScope;
    protected final ICommonsOrderedMap<String, String> m_aCustomData = new CommonsLinkedHashMap();
    protected EmailAttachmentList m_aEmailAttachments;
    protected Locale m_aDisplayLocale;
    protected boolean m_bInvokeCustomExceptionHandler = true;
    protected boolean m_bAddClassPath = false;
    protected int m_nDuplicateEliminiationCounter = 100;
    protected InternalErrorEmailSettings m_aCustomEmailSettings;

    public InternalErrorBuilder() {
        this.addCustomData("GlobalDebug.debug", GlobalDebug.isDebugMode());
        this.addCustomData("GlobalDebug.production", GlobalDebug.isProductionMode());
        File file = WebFileIO.getDataIO().getBasePathFile();
        this.addCustomData("Data Directory", file.getAbsolutePath());
        this.addCustomData("Usable bytes", Long.toString(file.getUsableSpace()));
        this.addCustomData("Free bytes", Long.toString(file.getFreeSpace()));
        this.addCustomData("ServletContext Base path", WebFileIO.getServletContextIO().getBasePath());
        try {
            this.addCustomData("User", LoggedInUserManager.getInstance().getCurrentUserID());
        }
        catch (Exception exception) {
            this.addCustomData("User", "Unknown");
        }
    }

    @Nonnull
    public final InternalErrorBuilder setSendEmail(boolean bl) {
        this.m_bSendEmail = bl;
        return this;
    }

    public boolean isSendEmail() {
        return this.m_bSendEmail;
    }

    @Nonnull
    public final InternalErrorBuilder setSaveAsXML(boolean bl) {
        this.m_bSaveAsXML = bl;
        return this;
    }

    public boolean isSaveAsXML() {
        return this.m_bSaveAsXML;
    }

    @Nonnull
    public final InternalErrorBuilder setUIErrorHandlerFor(@Nonnull IHCNodeWithChildren<?> iHCNodeWithChildren) {
        return this.setUIErrorHandler(new UIInternalErrorHandler(iHCNodeWithChildren));
    }

    @Nonnull
    public final InternalErrorBuilder setUIErrorHandler(@Nullable IUIInternalErrorHandler iUIInternalErrorHandler) {
        this.m_aUIErrorHandler = iUIInternalErrorHandler;
        return this;
    }

    @Nullable
    public IUIInternalErrorHandler getUIErrorHandler() {
        return this.m_aUIErrorHandler;
    }

    @Nonnull
    public final InternalErrorBuilder setThrowable(@Nullable Throwable throwable) {
        this.m_aThrowable = throwable;
        return this;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.m_aThrowable;
    }

    @Nonnull
    public final InternalErrorBuilder setRequestScope(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        this.m_aRequestScope = iRequestWebScopeWithoutResponse;
        return this;
    }

    @Nullable
    public IRequestWebScopeWithoutResponse getRequestScope() {
        return this.m_aRequestScope;
    }

    @Nonnull
    public final InternalErrorBuilder addErrorMessage(@Nullable String string) {
        return this.addCustomData(KEY_ERROR_MSG, string);
    }

    @Nullable
    public String getErrorMessage(@Nullable String string) {
        return (String)this.m_aCustomData.getOrDefault((Object)KEY_ERROR_MSG, (Object)string);
    }

    @Nonnull
    public final InternalErrorBuilder addCustomData(@Nonnull String string, boolean bl) {
        return this.addCustomData(string, Boolean.toString(bl));
    }

    @Nonnull
    public final InternalErrorBuilder addCustomData(@Nonnull String string, int n) {
        return this.addCustomData(string, Integer.toString(n));
    }

    @Nonnull
    public final InternalErrorBuilder addCustomData(@Nonnull String string, long l) {
        return this.addCustomData(string, Long.toString(l));
    }

    @Nonnull
    public final InternalErrorBuilder addCustomData(@Nonnull String string, @Nonnull Object object) {
        return this.addCustomData(string, String.valueOf(object));
    }

    @Nonnull
    public final InternalErrorBuilder addCustomData(@Nonnull String string, @Nullable String string2) {
        this.m_aCustomData.put((Object)string, (Object)string2);
        return this;
    }

    @Nonnull
    public final InternalErrorBuilder addCustomData(@Nullable Map<String, String> map) {
        if (map != null) {
            this.m_aCustomData.putAll(map);
        }
        return this;
    }

    @Nonnull
    public final InternalErrorBuilder setCustomData(@Nullable Map<String, String> map) {
        this.m_aCustomData.setAll(map);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllCustomData() {
        return this.m_aCustomData.getClone();
    }

    public void forEachCustomData(@Nonnull BiConsumer<String, String> biConsumer) {
        this.m_aCustomData.forEach(biConsumer);
    }

    @Nonnull
    public final InternalErrorBuilder addEmailAttachment(@Nonnull IEmailAttachment iEmailAttachment) {
        if (this.m_aEmailAttachments == null) {
            this.m_aEmailAttachments = new EmailAttachmentList();
        }
        this.m_aEmailAttachments.addAttachment(iEmailAttachment);
        return this;
    }

    @Nonnull
    public final InternalErrorBuilder setEmailAttachmentList(@Nullable IEmailAttachmentList iEmailAttachmentList) {
        this.m_aEmailAttachments = iEmailAttachmentList == null ? null : new EmailAttachmentList(iEmailAttachmentList);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public EmailAttachmentList getEmailAttachmentList() {
        return new EmailAttachmentList((IEmailAttachmentList)this.m_aEmailAttachments);
    }

    @Nonnull
    public final InternalErrorBuilder setDisplayLocale(@Nullable Locale locale) {
        this.m_aDisplayLocale = locale;
        return this;
    }

    @Nullable
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Nonnull
    public final InternalErrorBuilder setInvokeCustomExceptionHandler(boolean bl) {
        this.m_bInvokeCustomExceptionHandler = bl;
        return this;
    }

    public boolean isInvokeCustomExceptionHandler() {
        return this.m_bInvokeCustomExceptionHandler;
    }

    @Nonnull
    public final InternalErrorBuilder setAddClassPath(boolean bl) {
        this.m_bAddClassPath = bl;
        return this;
    }

    public boolean isAddClassPath() {
        return this.m_bAddClassPath;
    }

    @Nonnull
    public final InternalErrorBuilder setDuplicateEliminiationCounter(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"DuplicateEliminiationCounter");
        this.m_nDuplicateEliminiationCounter = n;
        return this;
    }

    @Nonnegative
    public int getDuplicateEliminationCounter() {
        return this.m_nDuplicateEliminiationCounter;
    }

    @Nonnull
    public final InternalErrorBuilder setFromWebExecutionContext(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext) {
        this.setDisplayLocale(iSimpleWebExecutionContext.getDisplayLocale());
        this.setRequestScope(iSimpleWebExecutionContext.getRequestScope());
        return this;
    }

    @Nonnull
    public final InternalErrorBuilder setCustomEmailSettings(@Nullable InternalErrorEmailSettings internalErrorEmailSettings) {
        this.m_aCustomEmailSettings = internalErrorEmailSettings;
        return this;
    }

    @Nonnull
    @Nonempty
    public String handle() {
        return InternalErrorHandler.handleInternalError(this.m_bSendEmail, this.m_bSaveAsXML, this.m_aUIErrorHandler, this.m_aThrowable, this.m_aRequestScope, this.m_aCustomData, (IEmailAttachmentList)this.m_aEmailAttachments, this.m_aDisplayLocale, this.m_bInvokeCustomExceptionHandler, this.m_bAddClassPath, this.m_nDuplicateEliminiationCounter, this.m_aCustomEmailSettings);
    }
}

