/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.html;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCConversionSettings;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.metadata.HCHead;
import com.helger.html.hc.html.metadata.HCMeta;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.meta.EStandardMetaElement;
import com.helger.html.meta.IMetaElement;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.mime.IMimeType;
import com.helger.photon.app.PhotonAppManager;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.html.IHTMLProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonHTMLHelper;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.app.html.PhotonMetaElements;
import com.helger.photon.app.resource.IWebSiteResourceBundleProvider;
import com.helger.photon.core.appid.RequestSettings;
import com.helger.text.locale.LocaleHelper;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.forcedredirect.ForcedRedirectException;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractHTMLProvider
implements IHTMLProvider {
    @Nonnull
    @OverrideOnDemand
    protected HCHtml createHCHtml(@Nonnull Locale locale) {
        return (HCHtml)new HCHtml().setLanguage(locale.getLanguage());
    }

    @OverrideOnDemand
    protected void addMetaElements(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull HCHead hCHead) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IMimeType iMimeType = PhotonHTMLHelper.getMimeType((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse);
        commonsArrayList.add((Object)EStandardMetaElement.CONTENT_TYPE.getAsMetaElement(iMimeType.getAsString()));
        PhotonMetaElements.getAllRegisteredMetaElementsForGlobal((Collection)commonsArrayList);
        PhotonMetaElements.getAllRegisteredMetaElementsForThisRequest((Collection)commonsArrayList);
        for (IMetaElement iMetaElement : commonsArrayList) {
            for (Map.Entry entry : iMetaElement.getContent()) {
                HCMeta hCMeta = new HCMeta();
                if (iMetaElement.isHttpEquiv()) {
                    hCMeta.setHttpEquiv(iMetaElement.getName());
                } else {
                    hCMeta.setName(iMetaElement.getName());
                }
                hCMeta.setContent((String)entry.getValue());
                Locale locale = (Locale)entry.getKey();
                if (locale != null && !LocaleHelper.isSpecialLocale((Locale)locale)) {
                    hCMeta.setLanguage(locale.toString());
                }
                hCHead.metaElements().add((Object)hCMeta);
            }
        }
    }

    @OverrideOnDemand
    protected void addGlobalAndPerRequestCSSAndJS(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull HCHtml hCHtml) {
        Object object2;
        boolean bl = HCSettings.isUseRegularResources();
        HCHead hCHead = hCHtml.head();
        ICommonsOrderedSet iCommonsOrderedSet = PhotonCSS.getAllRegisteredCSSIncludesForGlobal();
        PhotonCSS.getAllRegisteredCSSIncludesForThisRequest((Collection)iCommonsOrderedSet);
        for (Object object2 : iCommonsOrderedSet) {
            hCHead.addCSS(PhotonHTMLHelper.getCSSNode((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse, (ICSSPathProvider)object2, (boolean)bl));
        }
        Iterator iterator = PhotonJS.getAllRegisteredJSIncludesForGlobal();
        PhotonJS.getAllRegisteredJSIncludesForThisRequest((Collection)((Object)iterator));
        object2 = iterator.iterator();
        while (object2.hasNext()) {
            IJSPathProvider iJSPathProvider = (IJSPathProvider)object2.next();
            hCHead.addJS(PhotonHTMLHelper.getJSNode((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse, (IJSPathProvider)iJSPathProvider, (boolean)bl));
        }
    }

    protected abstract void fillHeadAndBody(@Nonnull IRequestWebScopeWithoutResponse var1, @Nonnull HCHtml var2, @Nonnull Locale var3);

    @Nonnull
    public final HCHtml createHTML(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) throws ForcedRedirectException {
        Locale locale = RequestSettings.getDisplayLocale(iRequestWebScopeWithoutResponse);
        HCConversionSettings hCConversionSettings = PhotonHTMLHelper.getHCConversionSettingsWithNonce();
        HCHtml hCHtml = this.createHCHtml(locale);
        this.fillHeadAndBody(iRequestWebScopeWithoutResponse, hCHtml, locale);
        HCRenderer.prepareForConversion((IHCNode)hCHtml, (IHCHasChildrenMutable)hCHtml.body(), (IHCConversionSettingsToNode)hCConversionSettings);
        this.addGlobalAndPerRequestCSSAndJS(iRequestWebScopeWithoutResponse, hCHtml);
        if (hCConversionSettings.isExtractOutOfBandNodes()) {
            ICommonsList iCommonsList = hCHtml.getAllOutOfBandNodesWithMergedInlineNodes();
            hCHtml.addAllOutOfBandNodesToHead((List)iCommonsList);
        }
        PhotonHTMLHelper.mergeExternalCSSAndJSNodes((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse, (HCHead)hCHtml.head(), (boolean)PhotonAppSettings.isMergeCSSResources(), (boolean)PhotonAppSettings.isMergeJSResources(), (IWebSiteResourceBundleProvider)PhotonAppManager.getWebSiteResourceBundleMgr());
        if (HCSettings.isScriptsInBody()) {
            hCHtml.moveScriptElementsToBody();
        }
        return hCHtml;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

