/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.go;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.photon.core.go.GoMappingItem;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.mgr.PhotonCoreManager;
import com.helger.photon.core.requestparam.RequestParameterManager;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.data.IURLData;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoXServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoXServletHandler.class);
    private static final IMutableStatisticsHandlerKeyedCounter STATS_ERROR = StatisticsManager.getKeyedCounterHandler((String)(GoXServletHandler.class.getName() + "$error"));
    private static final IMutableStatisticsHandlerKeyedCounter STATS_OK = StatisticsManager.getKeyedCounterHandler((String)(GoXServletHandler.class.getName() + "$ok"));
    private final Function<? super IRequestWebScopeWithoutResponse, ? extends IMenuTree> m_aMenuTreeSupplier;

    public GoXServletHandler(@Nonnull Function<? super IRequestWebScopeWithoutResponse, ? extends IMenuTree> function) {
        ValueEnforcer.notNull(function, (String)"MenuTreeSupplier");
        this.m_aMenuTreeSupplier = function;
    }

    @Nullable
    @OverrideOnDemand
    protected GoMappingItem getResolvedGoMappingItem(@Nonnull String string) {
        return PhotonCoreManager.getGoMappingMgr().getItemOfKey(string);
    }

    @Nonnull
    @OverrideOnDemand
    protected SimpleURL getURLForNonExistingItem(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        return new SimpleURL(iRequestWebScopeWithoutResponse.getFullContextPath());
    }

    @OverrideOnDemand
    protected void modifyResultURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string, @Nonnull SimpleURL simpleURL) {
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        Object object;
        String string = iRequestWebScopeWithoutResponse.getPathWithinServlet();
        if (string.length() > 0) {
            string = string.substring(1);
        }
        SimpleURL simpleURL = null;
        GoMappingItem goMappingItem = this.getResolvedGoMappingItem(string);
        if (goMappingItem == null) {
            LOGGER.warn("No such go-mapping item '" + string + "'");
            simpleURL = this.getURLForNonExistingItem(iRequestWebScopeWithoutResponse, string);
            STATS_ERROR.increment(string);
        } else {
            Object object2;
            Object object3;
            if (goMappingItem.isInternal() && (object3 = this.m_aMenuTreeSupplier.apply((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse)) != null && (object = (IMenuObject)object3.getItemDataWithID(object2 = RequestParameterManager.getInstance().getMenuItemFromURL((ISimpleURL)goMappingItem.getTargetURL(), (IMenuTree)object3))) instanceof IMenuItemExternal) {
                simpleURL = new SimpleURL((IURLData)((IMenuItemExternal)object).getURL());
            }
            if (simpleURL == null) {
                simpleURL = goMappingItem.getTargetURL();
            }
            this.modifyResultURL(iRequestWebScopeWithoutResponse, string, simpleURL);
            STATS_OK.increment(string);
        }
        for (Object object2 : iRequestWebScopeWithoutResponse.params().entrySet()) {
            object = (String)object2.getKey();
            Object v = object2.getValue();
            if (v instanceof String) {
                simpleURL.add((String)object, (String)v);
                continue;
            }
            if (!(v instanceof String[])) continue;
            for (String string2 : (String[])v) {
                simpleURL.add((String)object, string2);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Following go-mapping item '" + string + "' to " + simpleURL.getAsString());
        } else if (GlobalDebug.isDebugMode()) {
            LOGGER.info("Following go-mapping item '" + string + "' to " + simpleURL.getAsString());
        }
        unifiedResponse.setRedirect((ISimpleURL)simpleURL);
    }
}

