/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.go;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.dao.DAOException;
import com.helger.photon.app.url.LinkHelper;
import com.helger.photon.core.go.GoMappingItem;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.mgr.PhotonCoreManager;
import com.helger.photon.core.requestparam.RequestParameterManager;
import com.helger.photon.io.dao.AbstractPhotonSimpleDAO;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GoMappingManager
extends AbstractPhotonSimpleDAO {
    public static final boolean DEFAULT_EDITABLE = true;
    private static final String ELEMENT_ROOT = "gomappings";
    private static final String ELEMENT_EXTERNAL = "external";
    private static final String ELEMENT_INTERNAL = "internal";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_HREF = "href";
    private static final String ATTR_EDITABLE = "editable";
    private static final Logger LOGGER = LoggerFactory.getLogger(GoMappingManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, GoMappingItem> m_aMap = new CommonsHashMap();

    public GoMappingManager(@Nullable String string) throws DAOException {
        super(string);
        this.initialRead();
    }

    @Nonnull
    private static String _unifyKey(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    @MustBeLocked(value=ELockType.WRITE)
    private EChange _addItem(@Nonnull GoMappingItem goMappingItem, boolean bl) {
        ValueEnforcer.notNull((Object)goMappingItem, (String)"Item");
        String string = GoMappingManager._unifyKey(goMappingItem.getKey());
        GoMappingItem goMappingItem2 = (GoMappingItem)this.m_aMap.get((Object)string);
        if (goMappingItem2 != null) {
            if (bl) {
                if (goMappingItem2.equals(goMappingItem)) {
                    return EChange.UNCHANGED;
                }
            } else {
                throw new IllegalArgumentException("Another go-mapping with the key '" + string + "' is already registered!");
            }
        }
        this.m_aMap.put((Object)string, (Object)goMappingItem);
        return EChange.CHANGED;
    }

    public static void readFromXML(@Nonnull IMicroDocument iMicroDocument, @Nonnull Consumer<GoMappingItem> consumer) {
        ValueEnforcer.notNull((Object)iMicroDocument, (String)"Doc");
        ValueEnforcer.notNull(consumer, (String)"Callback");
        iMicroDocument.getDocumentElement().forAllChildElements(iMicroElement -> {
            String string = iMicroElement.getTagName();
            String string2 = iMicroElement.getAttributeValue(ATTR_KEY);
            String string3 = iMicroElement.getAttributeValue(ATTR_HREF);
            String string4 = iMicroElement.getAttributeValue(ATTR_EDITABLE);
            boolean bl = StringParser.parseBool((String)string4, (boolean)true);
            if (ELEMENT_EXTERNAL.equals(string)) {
                consumer.accept(new GoMappingItem(string2, false, string3, bl));
            } else if (ELEMENT_INTERNAL.equals(string)) {
                consumer.accept(new GoMappingItem(string2, true, string3, bl));
            } else {
                LOGGER.error("Unsupported go-mapping tag '" + string + "'");
            }
        });
    }

    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        GoMappingManager.readFromXML(iMicroDocument, goMappingItem -> this._addItem((GoMappingItem)goMappingItem, false));
        return EChange.UNCHANGED;
    }

    protected IMicroDocument createWriteData() {
        String string = ServletContextPathHolder.getContextPath();
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement(ELEMENT_ROOT);
        for (GoMappingItem goMappingItem : this.m_aMap.getSortedByKey(Comparator.naturalOrder()).values()) {
            IMicroElement iMicroElement2;
            if (goMappingItem.isInternal()) {
                iMicroElement2 = iMicroElement.addElement(ELEMENT_INTERNAL);
                iMicroElement2.setAttribute(ATTR_KEY, goMappingItem.getKey());
                iMicroElement2.setAttribute(ATTR_HREF, StringHelper.trimStart((String)goMappingItem.getTargetURLAsString(), (String)string));
                continue;
            }
            iMicroElement2 = iMicroElement.addElement(ELEMENT_EXTERNAL);
            iMicroElement2.setAttribute(ATTR_KEY, goMappingItem.getKey());
            iMicroElement2.setAttribute(ATTR_HREF, goMappingItem.getTargetURLAsString());
        }
        return microDocument;
    }

    public boolean isReloadable() {
        return true;
    }

    public void reload() throws DAOException {
        this.m_aRWLock.writeLockedThrowing(() -> {
            this.m_aMap.clear();
            this.initialRead();
        });
        LOGGER.info("Reloaded " + this.m_aMap.size() + " go-mappings!");
    }

    @Nonnull
    public EChange addItem(@Nonnull @Nonempty String string, boolean bl, @Nonnull @Nonempty String string2, boolean bl2) {
        return this.addItem(new GoMappingItem(string, bl, string2, bl2));
    }

    @Nonnull
    public EChange addItem(@Nonnull GoMappingItem goMappingItem) {
        ValueEnforcer.notNull((Object)goMappingItem, (String)"Item");
        String string = GoMappingManager._unifyKey(goMappingItem.getKey());
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aMap.containsKey((Object)string)) {
                return EChange.UNCHANGED;
            }
            this._addItem(goMappingItem, false);
            this.markAsChanged();
            return EChange.CHANGED;
        });
    }

    @Nonnull
    public EChange setItem(@Nonnull @Nonempty String string, boolean bl, @Nonnull @Nonempty String string2, boolean bl2) {
        return this.setItem(new GoMappingItem(string, bl, string2, bl2));
    }

    @Nonnull
    public EChange setItem(@Nonnull GoMappingItem goMappingItem) {
        ValueEnforcer.notNull((Object)goMappingItem, (String)"Item");
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this._addItem(goMappingItem, true).isUnchanged()) {
                return EChange.UNCHANGED;
            }
            this.markAsChanged();
            return EChange.CHANGED;
        });
    }

    @Nonnull
    public EChange removeItem(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        String string2 = GoMappingManager._unifyKey(string);
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aMap.remove((Object)string2) == null) {
                return EChange.UNCHANGED;
            }
            this.markAsChanged();
            return EChange.CHANGED;
        });
    }

    @Nonnull
    public EChange removeAllItems() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aMap.removeAll().isUnchanged()) {
                return EChange.UNCHANGED;
            }
            this.markAsChanged();
            return EChange.CHANGED;
        });
    }

    public boolean containsItemWithKey(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        String string2 = GoMappingManager._unifyKey(string);
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.containsKey((Object)string2));
    }

    @Nullable
    public GoMappingItem getItemOfKey(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        String string2 = GoMappingManager._unifyKey(string);
        return (GoMappingItem)this.m_aRWLock.readLockedGet(() -> (GoMappingItem)this.m_aMap.get((Object)string2));
    }

    @Nonnegative
    public int getItemCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aMap.size());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, GoMappingItem> getAllItems() {
        return (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aMap.getClone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int checkInternalMappings(@Nonnull IMenuTree iMenuTree, @Nonnull Consumer<GoMappingItem> consumer) {
        ValueEnforcer.notNull((Object)iMenuTree, (String)"MenuTree");
        ValueEnforcer.notNull(consumer, (String)"ErrorCallback");
        RequestParameterManager requestParameterManager = RequestParameterManager.getInstance();
        int n = 0;
        int n2 = 0;
        this.m_aRWLock.readLock().lock();
        try {
            for (GoMappingItem goMappingItem : this.m_aMap.values()) {
                String string;
                if (!goMappingItem.isInternal() || (string = requestParameterManager.getMenuItemFromURL(goMappingItem.getTargetURLReadonly(), iMenuTree)) == null) continue;
                ++n;
                if (iMenuTree.getItemWithID(string) != null) continue;
                ++n2;
                consumer.accept(goMappingItem);
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (n2 == 0) {
            LOGGER.info("Successfully checked " + n + " internal go-mappings for consistency");
        } else {
            LOGGER.warn("Checked " + n + " internal go-mappings for consistency and found " + n2 + " errors!");
        }
        return n2;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }

    @Nonnull
    public static SimpleURL getGoLink(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        if (PhotonCoreManager.getGoMappingMgr().getItemOfKey(string) == null) {
            LOGGER.warn("Building URL from non-existing go-mapping item '" + string + "'");
        }
        return LinkHelper.getURLWithContext((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse, (String)("go/" + string));
    }

    @Nonnull
    public static String getGoLinkURI(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        if (PhotonCoreManager.getGoMappingMgr().getItemOfKey(string) == null) {
            LOGGER.warn("Building URI from non-existing go-mapping item '" + string + "'");
        }
        return LinkHelper.getURIWithContext((String)("go/" + string));
    }
}

