/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.go;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.app.url.LinkHelper;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.data.IURLData;
import jakarta.annotation.Nonnull;
import java.io.Serializable;

@Immutable
public class GoMappingItem
implements Serializable {
    private final String m_sKey;
    private final boolean m_bIsInternal;
    private final ISimpleURL m_aTargetURL;
    private final boolean m_bIsEditable;

    public GoMappingItem(@Nonnull @Nonempty String string, boolean bl, @Nonnull @Nonempty String string2, boolean bl2) {
        this(string, bl, (ISimpleURL)(bl ? LinkHelper.getURLWithContext((String)string2) : new SimpleURL(string2)), bl2);
    }

    public GoMappingItem(@Nonnull @Nonempty String string, boolean bl, @Nonnull ISimpleURL iSimpleURL, boolean bl2) {
        this.m_sKey = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        this.m_bIsInternal = bl;
        this.m_aTargetURL = (ISimpleURL)ValueEnforcer.notNull((Object)iSimpleURL, (String)"TargetURL");
        this.m_bIsEditable = bl2;
    }

    @Nonnull
    @Nonempty
    public String getKey() {
        return this.m_sKey;
    }

    public boolean isInternal() {
        return this.m_bIsInternal;
    }

    @Nonnull
    public ISimpleURL getTargetURLReadonly() {
        return this.m_aTargetURL;
    }

    @Nonnull
    @ReturnsMutableCopy
    public SimpleURL getTargetURL() {
        return new SimpleURL((IURLData)this.m_aTargetURL);
    }

    @Nonnull
    public String getTargetURLAsString() {
        return this.m_aTargetURL.getAsString();
    }

    public boolean isEditable() {
        return this.m_bIsEditable;
    }

    @Nonnull
    public GoMappingItem getAsNotEditable() {
        if (!this.m_bIsEditable) {
            return this;
        }
        return new GoMappingItem(this.m_sKey, this.m_bIsInternal, this.m_aTargetURL, false);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        GoMappingItem goMappingItem = (GoMappingItem)object;
        return this.m_sKey.equals(goMappingItem.m_sKey) && this.m_bIsInternal == goMappingItem.m_bIsInternal && this.m_aTargetURL.equals((Object)goMappingItem.m_aTargetURL) && this.m_bIsEditable == goMappingItem.m_bIsEditable;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sKey).append(this.m_bIsInternal).append((Object)this.m_aTargetURL).append(this.m_bIsEditable).getHashCode();
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator((Object)this).append("key", (Object)this.m_sKey).append("isInternal", this.m_bIsInternal).append("target", (Object)this.m_aTargetURL).append("isEditable", this.m_bIsEditable).getToString();
    }
}

