/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.form;

import com.helger.annotation.Nonempty;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.photon.core.form.RequestFieldBoolean;
import com.helger.photon.core.form.SessionBackedRequestField;
import com.helger.web.scope.IRequestParamContainer;
import jakarta.annotation.Nonnull;

public class SessionBackedRequestFieldBoolean
extends SessionBackedRequestField
implements IHCRequestFieldBoolean {
    private final boolean m_bDefaultValue;

    public SessionBackedRequestFieldBoolean(@Nonnull @Nonempty String string, boolean bl) {
        super(string, RequestFieldBoolean.getStringValue(bl));
        this.m_bDefaultValue = bl;
    }

    public boolean isChecked(@Nonnull IRequestParamContainer iRequestParamContainer) {
        return iRequestParamContainer.isCheckBoxChecked(this.getFieldName(), this.m_bDefaultValue);
    }

    public boolean isChecked() {
        return this.isChecked(SessionBackedRequestFieldBoolean.getParams());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SessionBackedRequestFieldBoolean sessionBackedRequestFieldBoolean = (SessionBackedRequestFieldBoolean)((Object)object);
        return this.m_bDefaultValue == sessionBackedRequestFieldBoolean.m_bDefaultValue;
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bDefaultValue).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DefaultValue", this.m_bDefaultValue).getToString();
    }
}

