/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.form;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.format.PDTToString;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.util.PDTXMLConverter;
import com.helger.photon.core.form.RequestField;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Locale;
import javax.xml.datatype.XMLGregorianCalendar;

public class RequestFieldDate
extends RequestField {
    private final Locale m_aDisplayLocale;

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Locale locale) {
        super(string, string2);
        this.m_aDisplayLocale = (Locale)ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        this(string, (String)null, locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable LocalDate localDate, @Nonnull Locale locale) {
        this(string, PDTToString.getAsString((LocalDate)localDate, (Locale)locale), locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable LocalTime localTime, @Nonnull Locale locale) {
        this(string, PDTToString.getAsString((LocalTime)localTime, (Locale)locale), locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable LocalDateTime localDateTime, @Nonnull Locale locale) {
        this(string, PDTToString.getAsString((LocalDateTime)localDateTime, (Locale)locale), locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable ZonedDateTime zonedDateTime, @Nonnull Locale locale) {
        this(string, PDTToString.getAsString((ZonedDateTime)zonedDateTime, (Locale)locale), locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable XMLGregorianCalendar xMLGregorianCalendar, @Nonnull Locale locale) {
        this(string, PDTXMLConverter.getZonedDateTime((XMLGregorianCalendar)xMLGregorianCalendar), locale);
    }

    @Nonnull
    public final Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RequestFieldDate requestFieldDate = (RequestFieldDate)((Object)object);
        return this.m_aDisplayLocale.equals(requestFieldDate.m_aDisplayLocale);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aDisplayLocale).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DisplayLocale", (Object)this.m_aDisplayLocale).getToString();
    }

    @Nonnull
    public static RequestFieldDate createLocalDateNow(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        return new RequestFieldDate(string, PDTFactory.getCurrentLocalDate(), locale);
    }

    @Nonnull
    public static RequestFieldDate createLocalDateTimeNow(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        return new RequestFieldDate(string, PDTFactory.getCurrentLocalDateTime(), locale);
    }

    @Nonnull
    public static RequestFieldDate createDateTimeNow(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        return new RequestFieldDate(string, PDTFactory.getCurrentZonedDateTime(), locale);
    }
}

