/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.form;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.request.IHCRequestFieldBooleanMultiValue;
import com.helger.photon.core.form.RequestField;
import jakarta.annotation.Nonnull;

public class RequestFieldBooleanMultiValue
extends RequestField
implements IHCRequestFieldBooleanMultiValue {
    private final String m_sValue;
    private final boolean m_bDefaultValue;

    public RequestFieldBooleanMultiValue(@Nonnull @Nonempty String string, @Nonnull String string2, boolean bl) {
        super(string, bl ? string2 : null);
        this.m_sValue = (String)ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_bDefaultValue = bl;
    }

    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    public boolean isChecked() {
        return RequestFieldBooleanMultiValue.getParams().hasCheckBoxValue(this.getFieldName(), this.m_sValue, this.m_bDefaultValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RequestFieldBooleanMultiValue requestFieldBooleanMultiValue = (RequestFieldBooleanMultiValue)((Object)object);
        return this.m_sValue.equals(requestFieldBooleanMultiValue.m_sValue) && this.m_bDefaultValue == requestFieldBooleanMultiValue.m_bDefaultValue;
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sValue).append(this.m_bDefaultValue).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Value", (Object)this.m_sValue).append("DefaultValue", this.m_bDefaultValue).getToString();
    }
}

