/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.favorites;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ObjectType;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.dao.DAOException;
import com.helger.dao.EDAOActionType;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.core.favorites.Favorite;
import com.helger.photon.core.favorites.IFavorite;
import com.helger.photon.io.dao.AbstractPhotonWALDAO;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class FavoriteManager
extends AbstractPhotonWALDAO<Favorite> {
    private static final String ELEMENT_ITEM = "favorite";
    private final ICommonsMap<String, ICommonsList<Favorite>> m_aMap = new CommonsHashMap();

    public FavoriteManager(@Nonnull @Nonempty String string) throws DAOException {
        super(Favorite.class, string);
        this.initialRead();
    }

    protected void onRecoveryCreate(@Nonnull Favorite favorite) {
        this._addItem(favorite);
    }

    protected void onRecoveryUpdate(@Nonnull Favorite favorite) {
        this._addItem(favorite);
    }

    protected void onRecoveryDelete(@Nonnull Favorite favorite) {
        ICommonsList iCommonsList = (ICommonsList)this.m_aMap.get((Object)favorite.getUserID());
        if (iCommonsList != null) {
            iCommonsList.remove((Object)favorite);
        }
    }

    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_ITEM)) {
            this._addItem((Favorite)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement, Favorite.class));
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement("root");
        for (ICommonsList iCommonsList : this.m_aMap.getSortedByKey(Comparator.naturalOrder()).values()) {
            for (Favorite favorite : iCommonsList) {
                iMicroElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)favorite, (String)ELEMENT_ITEM));
            }
        }
        return microDocument;
    }

    public boolean isReloadable() {
        return true;
    }

    public void reload() throws DAOException {
        this.m_aRWLock.writeLockedThrowing(() -> {
            this.m_aMap.clear();
            this.initialRead();
        });
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _addItem(@Nonnull Favorite favorite) {
        ValueEnforcer.notNull((Object)favorite, (String)"Favorite");
        ((ICommonsList)this.m_aMap.computeIfAbsent((Object)favorite.getUserID(), string -> new CommonsArrayList())).add((Object)favorite);
    }

    @Nonnegative
    public long getSize() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aMap.values().stream().mapToInt(ICommonsCollection::size).sum());
    }

    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.isEmpty());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllUserIDsWithFavorites() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfKeySet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IFavorite> getAllFavoritesOfUser(@Nullable String string) {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> new CommonsArrayList((Collection)this.m_aMap.get((Object)string)));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, ICommonsList<IFavorite>> getAll() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            commonsHashMap.put((Object)((String)entry.getKey()), (Object)new CommonsArrayList((Collection)entry.getValue()));
        }
        return commonsHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IFavorite> getAllFavorites() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            commonsArrayList.addAll((Collection)entry.getValue());
        }
        return commonsArrayList;
    }

    public boolean containsFavoritesOfUser(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get((Object)string));
        return iCommonsList != null && iCommonsList.isNotEmpty();
    }

    public boolean isFavorite(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        return this.getFavorite(string, string2, string3, map) != null;
    }

    @Nullable
    public IFavorite getFavorite(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        ICommonsList iCommonsList;
        if (StringHelper.isNotEmpty((String)string) && StringHelper.isNotEmpty((String)string2) && StringHelper.isNotEmpty((String)string3) && (iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get((Object)string))) != null) {
            return (IFavorite)iCommonsList.findFirst(favorite -> favorite.hasSameContent(string2, string3, map));
        }
        return null;
    }

    @Nullable
    public IFavorite getFavorite(@Nullable String string, @Nullable String string2) {
        ICommonsList iCommonsList;
        if (StringHelper.isNotEmpty((String)string) && StringHelper.isNotEmpty((String)string2) && (iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get((Object)string))) != null) {
            return (IFavorite)iCommonsList.findFirst(favorite -> favorite.getID().equals(string2));
        }
        return null;
    }

    @Nonnull
    public IFavorite addFavorite(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nullable Map<String, String> map) {
        Favorite favorite = new Favorite(string, string2, string3, string4, map);
        this.m_aRWLock.writeLocked(() -> {
            this._addItem(favorite);
            this.markAsChanged(favorite, EDAOActionType.CREATE);
        });
        AuditHelper.onAuditCreateSuccess((ObjectType)Favorite.OT, (Object[])new Object[]{favorite.getID(), string, string2, string3, string4, map});
        return favorite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange updateFavorite(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nullable Map<String, String> map) {
        Favorite favorite2;
        ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get((Object)string));
        Favorite favorite3 = favorite2 = iCommonsList == null ? null : (Favorite)iCommonsList.findFirst(favorite -> favorite.getID().equals(string2));
        if (favorite2 == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)Favorite.OT, (String)string2, (Object[])new Object[]{"no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or((IChangeIndicator)favorite2.setMenuItemID(string3));
            eChange = eChange.or((IChangeIndicator)favorite2.setDisplayName(string4));
            eChange = eChange.or((IChangeIndicator)favorite2.setAdditionalParams(map));
            if (eChange.isUnchanged()) {
                AuditHelper.onAuditModifyFailure((ObjectType)Favorite.OT, (String)favorite2.getID(), (Object[])new Object[]{"unchanged"});
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            this.markAsChanged(favorite2, EDAOActionType.UPDATE);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)Favorite.OT, (String)favorite2.getID(), (Object[])new Object[]{string, string3, string4, map});
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange removeFavorite(@Nullable String string, @Nullable String string2) {
        Favorite favorite2;
        ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get((Object)string));
        Favorite favorite3 = favorite2 = iCommonsList == null ? null : (Favorite)iCommonsList.findFirst(favorite -> favorite.getID().equals(string2));
        if (favorite2 == null) {
            AuditHelper.onAuditDeleteFailure((ObjectType)Favorite.OT, (Object[])new Object[]{string, string2, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (iCommonsList.removeObject((Object)favorite2).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure((ObjectType)Favorite.OT, (Object[])new Object[]{string2, "no-such-id"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.markAsChanged(favorite2, EDAOActionType.DELETE);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)Favorite.OT, (Object[])new Object[]{string2});
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange removeAllFavoritesOfUser(@Nullable String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            ICommonsList iCommonsList = (ICommonsList)this.m_aMap.remove((Object)string);
            if (iCommonsList == null) {
                AuditHelper.onAuditDeleteFailure((ObjectType)Favorite.OT, (Object[])new Object[]{string, "no-such-user-id"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.markAsChanged((List)iCommonsList, EDAOActionType.DELETE);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)Favorite.OT, (Object[])new Object[]{string});
        return EChange.CHANGED;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

