/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.favorites;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ObjectType;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.photon.core.favorites.IFavorite;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@NotThreadSafe
public class Favorite
implements IFavorite {
    public static final ObjectType OT = new ObjectType("favourite");
    private final String m_sID;
    private final String m_sUserID;
    private final String m_sApplicationID;
    private String m_sMenuItemID;
    private String m_sDisplayName;
    private ICommonsMap<String, String> m_aAdditionalParams;

    public Favorite(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nullable Map<String, String> map) {
        this(GlobalIDFactory.getNewPersistentStringID(), string, string2, string3, string4, map);
    }

    Favorite(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5, @Nullable Map<String, String> map) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_sUserID = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"User ID");
        this.m_sApplicationID = (String)ValueEnforcer.notEmpty((CharSequence)string3, (String)"application ID");
        this.setMenuItemID(string4);
        this.setDisplayName(string5);
        this.setAdditionalParams(map);
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getUserID() {
        return this.m_sUserID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getApplicationID() {
        return this.m_sApplicationID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getMenuItemID() {
        return this.m_sMenuItemID;
    }

    @Nonnull
    public final EChange setMenuItemID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"menu item ID");
        if (string.equals(this.m_sMenuItemID)) {
            return EChange.UNCHANGED;
        }
        this.m_sMenuItemID = string;
        return EChange.CHANGED;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public final EChange setDisplayName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"display name");
        if (string.equals(this.m_sDisplayName)) {
            return EChange.UNCHANGED;
        }
        this.m_sDisplayName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllAdditionalParams() {
        return (ICommonsMap)this.m_aAdditionalParams.getClone();
    }

    @Nonnull
    public final EChange setAdditionalParams(@Nullable Map<String, String> map) {
        CommonsHashMap commonsHashMap = new CommonsHashMap(map);
        if (commonsHashMap.equals(this.m_aAdditionalParams)) {
            return EChange.UNCHANGED;
        }
        this.m_aAdditionalParams = commonsHashMap;
        return EChange.CHANGED;
    }

    @Override
    public boolean hasSameContent(@Nullable String string, @Nullable String string2, @Nullable Map<String, String> map) {
        CommonsHashMap commonsHashMap = new CommonsHashMap(map);
        return this.m_sApplicationID.equals(string) && this.m_sMenuItemID.equals(string2) && this.m_aAdditionalParams.equals((Object)commonsHashMap);
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator((Object)this).append("id", (Object)this.m_sID).append("userID", (Object)this.m_sUserID).append("applicationID", (Object)this.m_sApplicationID).append("menuItemID", (Object)this.m_sMenuItemID).append("displayName", (Object)this.m_sDisplayName).append("additionalParams", this.m_aAdditionalParams).getToString();
    }
}

