/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.execcontext;

import com.helger.annotation.Nonempty;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.requestparam.RequestParameterManager;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.user.IUser;
import com.helger.servlet.request.IRequestParamMap;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestParamContainer;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public interface ISimpleWebExecutionContext {
    @Nonnull
    public IRequestWebScopeWithoutResponse getRequestScope();

    @Nonnull
    default public IRequestParamContainer params() {
        return this.getRequestScope().params();
    }

    @Nonnull
    default public IRequestParamMap getRequestParamMap() {
        return this.getRequestScope().getRequestParamMap();
    }

    @Nonnull
    public Locale getDisplayLocale();

    @Nonnull
    public IMenuTree getMenuTree();

    @Nullable
    public IUser getLoggedInUser();

    @Nullable
    default public String getLoggedInUserID() {
        IUser iUser = this.getLoggedInUser();
        return iUser == null ? null : (String)iUser.getID();
    }

    public boolean isLoggedInUserAdministrator();

    default public boolean hasLoggedInUserRole(@Nullable String string) {
        String string2 = this.getLoggedInUserID();
        return string2 != null && PhotonSecurityManager.getUserGroupMgr().containsAnyUserGroupWithAssignedUserAndRole(string2, string);
    }

    @Nonnull
    default public SimpleURL getLinkToMenuItem(@Nonnull String string) {
        return this.getLinkToMenuItem(this.getDisplayLocale(), string);
    }

    @Nonnull
    default public SimpleURL getLinkToMenuItem(@Nonnull Locale locale, @Nonnull String string) {
        return RequestParameterManager.getInstance().getLinkToMenuItem(this.getRequestScope(), locale, string);
    }

    @Nonnull
    default public SimpleURL getLinkToMenuItem(@Nonnull @Nonempty String string, @Nonnull String string2) {
        return this.getLinkToMenuItem(string, this.getDisplayLocale(), string2);
    }

    @Nonnull
    default public SimpleURL getLinkToMenuItem(@Nonnull @Nonempty String string, @Nonnull Locale locale, @Nonnull String string2) {
        return RequestParameterManager.getInstance().getLinkToMenuItem(string, this.getRequestScope(), locale, string2);
    }
}

