/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.configfile;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.config.IConfig;
import com.helger.config.json.source.ConfigurationSourceJson;
import com.helger.config.source.resource.IConfigurationSourceResource;
import com.helger.config.source.resource.properties.ConfigurationSourceProperties;
import com.helger.photon.core.configfile.ConfigurationFile;
import com.helger.photon.core.configfile.EConfigurationFileSyntax;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationFileManager
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFileManager.class);
    private final ICommonsOrderedMap<String, ConfigurationFile> m_aMap = new CommonsLinkedHashMap();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public ConfigurationFileManager() {
    }

    @Nonnull
    public static ConfigurationFileManager getInstance() {
        return (ConfigurationFileManager)ConfigurationFileManager.getGlobalSingleton(ConfigurationFileManager.class);
    }

    public void registerConfigurationFile(@Nonnull ConfigurationFile configurationFile) {
        ValueEnforcer.notNull((Object)configurationFile, (String)"ConfigurationFile");
        String string = configurationFile.getID();
        if (this.m_aMap.containsKey((Object)string)) {
            throw new IllegalArgumentException("A configuration file " + string + " is already registered!");
        }
        this.m_aMap.put((Object)string, (Object)configurationFile);
    }

    public void registerAll(@Nonnull IConfig iConfig) {
        ValueEnforcer.notNull((Object)iConfig, (String)"Config");
        iConfig.forEachConfigurationValueProvider((iConfigurationValueProvider, n) -> {
            if (iConfigurationValueProvider instanceof IConfigurationSourceResource) {
                IConfigurationSourceResource iConfigurationSourceResource = (IConfigurationSourceResource)iConfigurationValueProvider;
                EConfigurationFileSyntax eConfigurationFileSyntax = iConfigurationSourceResource instanceof ConfigurationSourceJson ? EConfigurationFileSyntax.JSON : (iConfigurationSourceResource instanceof ConfigurationSourceProperties ? EConfigurationFileSyntax.PROPERTIES : EConfigurationFileSyntax.NONE);
                ConfigurationFile configurationFile = new ConfigurationFile(iConfigurationSourceResource.getResource()).setSyntaxHighlightLanguage(eConfigurationFileSyntax).setDescription("Configuration Source; priority: " + iConfigurationSourceResource.getPriority());
                if (!this.m_aMap.containsKey((Object)configurationFile.getID())) {
                    this.registerConfigurationFile(configurationFile);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignoring Configuration file '" + iConfigurationSourceResource.getResource().getPath() + "' because it is already registered.");
                }
            }
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ConfigurationFile> getAllConfigurationFiles() {
        return this.m_aMap.copyOfValues();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Map", this.m_aMap).getToString();
    }
}

