/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.configfile;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.core.configfile.EConfigurationFileSyntax;
import com.helger.text.IHasDescription;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@NotThreadSafe
public class ConfigurationFile
implements IHasID<String>,
IHasDescription {
    private final IReadableResource m_aRes;
    private final String m_sID;
    private String m_sDescription;
    private Charset m_aDefaultCharset = StandardCharsets.UTF_8;
    private EConfigurationFileSyntax m_eSyntaxHighlightLanguage = EConfigurationFileSyntax.NONE;

    @Nonnull
    private static String _unify(@Nonnull String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    public ConfigurationFile(@Nonnull IReadableResource iReadableResource) {
        this.m_aRes = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_sID = ConfigurationFile._unify(this.m_aRes.getPath());
    }

    @Nonnull
    public final String getID() {
        return this.m_sID;
    }

    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aRes;
    }

    public boolean exists() {
        return this.m_aRes.exists();
    }

    @Nullable
    public String getContentAsString() {
        return this.getContentAsString(this.m_aDefaultCharset);
    }

    @Nullable
    public String getContentAsString(@Nonnull Charset charset) {
        return StreamHelper.getAllBytesAsString((IHasInputStream)this.m_aRes, (Charset)charset);
    }

    @Nullable
    public final String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    public final ConfigurationFile setDescription(@Nullable String string) {
        this.m_sDescription = string;
        return this;
    }

    @Nonnull
    public final Charset getDefaultCharset() {
        return this.m_aDefaultCharset;
    }

    @Nonnull
    public final ConfigurationFile setDefaultCharset(@Nonnull Charset charset) {
        this.m_aDefaultCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"DefaultCharset");
        return this;
    }

    @Nonnull
    public final EConfigurationFileSyntax getSyntaxHighlightLanguage() {
        return this.m_eSyntaxHighlightLanguage;
    }

    @Nonnull
    public final ConfigurationFile setSyntaxHighlightLanguage(@Nonnull EConfigurationFileSyntax eConfigurationFileSyntax) {
        this.m_eSyntaxHighlightLanguage = (EConfigurationFileSyntax)((Object)ValueEnforcer.notNull((Object)((Object)eConfigurationFileSyntax), (String)"SyntaxHighlightLanguage"));
        return this;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Resource", (Object)this.m_aRes).append("ID", (Object)this.m_sID).append("Description", (Object)this.m_sDescription).append("DefaultCharset", (Object)this.m_aDefaultCharset).append("Syntax", (Enum)this.m_eSyntaxHighlightLanguage).getToString();
    }
}

