/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.buildinfo;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.datetime.helper.PDTFactory;
import com.helger.io.resource.IReadableResource;
import com.helger.typeconvert.trait.IGetterByKeyTrait;
import com.helger.xml.microdom.util.XMLMapHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.LocalDateTime;
import java.util.Map;

public final class BuildInfo
implements IGetterByKeyTrait<String> {
    public static final String BUILDINFO_FILENAME_XML = "META-INF/buildinfo.xml";
    private static final String PREFIX_SYSPROPERTY = "systemproperty.";
    private static final String PREFIX_ENVVAR = "envvar.";
    private final ICommonsMap<String, String> m_aMap;
    private final int m_nVersion;
    private final ICommonsMap<String, String> m_aSysProperties = new CommonsHashMap();
    private final ICommonsMap<String, String> m_aEnvVars = new CommonsHashMap();

    public BuildInfo(@Nonnull ICommonsMap<String, String> iCommonsMap) {
        this.m_aMap = (ICommonsMap)ValueEnforcer.notNull(iCommonsMap, (String)"Map");
        this.m_nVersion = this.getAsInt("buildinfo.version", 0);
        if (this.m_nVersion < 1) {
            throw new IllegalArgumentException("The passed map is not a buildinfo map!");
        }
        for (Map.Entry entry : iCommonsMap.entrySet()) {
            String string = (String)entry.getKey();
            if (string.startsWith(PREFIX_SYSPROPERTY)) {
                this.m_aSysProperties.put((Object)string.substring(PREFIX_SYSPROPERTY.length()), (Object)((String)entry.getValue()));
                continue;
            }
            if (!string.startsWith(PREFIX_ENVVAR)) continue;
            this.m_aEnvVars.put((Object)string.substring(PREFIX_ENVVAR.length()), (Object)((String)entry.getValue()));
        }
    }

    @Nonnegative
    public int getVersion() {
        return this.m_nVersion;
    }

    @Nullable
    public String getValue(@Nullable String string) {
        return (String)this.m_aMap.get((Object)string);
    }

    @Nonnull
    public String getProjectGroupID() {
        return this.getAsString("project.groupid");
    }

    @Nonnull
    public String getProjectArtifactID() {
        return this.getAsString("project.artifactid");
    }

    @Nonnull
    public String getProjectVersion() {
        return this.getAsString("project.version");
    }

    @Nonnull
    public String getProjectName() {
        return this.getAsString("project.name");
    }

    @Nonnull
    public String getProjectPackaging() {
        return this.getAsString("project.packaging");
    }

    @Nonnull
    public String getParentProjectGroupID() {
        return this.getAsString("parentproject.groupid");
    }

    @Nonnull
    public String getParentProjectArtifactID() {
        return this.getAsString("parentproject.artifactid");
    }

    @Nonnull
    public String getParentProjectVersion() {
        return this.getAsString("parentproject.version");
    }

    @Nonnull
    public String getParentProjectName() {
        return this.getAsString("parentproject.name");
    }

    @Nonnegative
    public int getBuildPluginCount() {
        return this.getAsInt("build.plugin.count", 0);
    }

    @Nonnull
    public String getBuildPluginGroupID(@Nonnegative int n) {
        return this.getAsString("build.plugin." + n + ".groupid");
    }

    @Nonnull
    public String getBuildPluginArtifactID(@Nonnegative int n) {
        return this.getAsString("build.plugin." + n + ".artifactid");
    }

    @Nonnull
    public String getBuildPluginVersion(@Nonnegative int n) {
        return this.getAsString("build.plugin." + n + ".version");
    }

    @Nonnull
    public String getBuildPluginConfiguration(@Nonnegative int n) {
        return this.getAsString("build.plugin." + n + ".configuration");
    }

    public String getBuildPluginKey(@Nonnegative int n) {
        return this.getAsString("build.plugin." + n + ".key");
    }

    @Nonnegative
    public int getDependencyCount() {
        return this.getAsInt("dependency.count", 0);
    }

    @Nonnull
    public String getDependencyGroupID(@Nonnegative int n) {
        return this.getAsString("dependency." + n + ".groupid");
    }

    @Nonnull
    public String getDependencyArtifactID(@Nonnegative int n) {
        return this.getAsString("dependency." + n + ".artifactid");
    }

    @Nonnull
    public String getDependencyVersion(@Nonnegative int n) {
        return this.getAsString("dependency." + n + ".version");
    }

    @Nonnull
    public String getDependencyType(@Nonnegative int n) {
        return this.getAsString("dependency." + n + ".type");
    }

    @Nullable
    public String getDependencyClassifier(@Nonnegative int n) {
        return this.getAsString("dependency." + n + ".classifier");
    }

    @Nonnull
    public String getDependencyScope(@Nonnegative int n) {
        return this.getAsString("dependency." + n + ".scope");
    }

    @Nullable
    public String getDependencySystemPath(@Nonnegative int n) {
        return this.getAsString("dependency." + n + ".systempath");
    }

    public boolean isDependencyOptional(@Nonnegative int n) {
        return this.getAsBoolean("dependency." + n + ".optional");
    }

    @Nonnull
    public String getDependencyManagementKey(@Nonnegative int n) {
        return this.getAsString("dependency." + n + ".managementkey");
    }

    @Nonnull
    public LocalDateTime getBuildDateTime() {
        return PDTFactory.createLocalDateTime((long)this.getAsLong("build.datetime.millis", 0L));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllSystemProperties() {
        return (ICommonsMap)this.m_aSysProperties.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllEnvVars() {
        return (ICommonsMap)this.m_aEnvVars.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("version", this.m_nVersion).append("map", this.m_aMap).getToString();
    }

    @Nullable
    public static BuildInfo createFromResource(@Nonnull IReadableResource iReadableResource) {
        ICommonsMap iCommonsMap = XMLMapHandler.readMap((IHasInputStream)iReadableResource);
        if (iCommonsMap == null) {
            return null;
        }
        return new BuildInfo((ICommonsMap<String, String>)iCommonsMap);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    public static @interface SinceBuildInfoV2 {
    }
}

