/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.audit;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.photon.audit.AuditHelper;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.TrackedRequest;
import jakarta.annotation.Nonnull;
import java.util.List;

public class AuditingParallelRunningRequestCallback
implements IParallelRunningRequestCallback {
    public static final AuditingParallelRunningRequestCallback INSTANCE = new AuditingParallelRunningRequestCallback();

    public void onParallelRunningRequests(@Nonnegative int n, @Nonnull @Nonempty List<TrackedRequest> list) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (TrackedRequest trackedRequest : list) {
            commonsArrayList.add((Object)trackedRequest.getRequestScope().getURLDecoded());
        }
        AuditHelper.onAuditExecuteSuccess((String)"parallel-running-requests", (Object[])new Object[]{n, commonsArrayList});
    }

    public void onParallelRunningRequestsBelowLimit() {
        AuditHelper.onAuditExecuteSuccess((String)"parallel-running-requests", (Object[])new Object[]{"back-to-normal"});
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

