/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.photon.core.appid.PhotonGlobalState;
import com.helger.photon.core.appid.PhotonGlobalStatePerApp;
import com.helger.photon.core.appid.PhotonRequestState;
import com.helger.photon.core.appid.PhotonSessionState;
import com.helger.photon.core.appid.PhotonSessionStatePerApp;
import com.helger.photon.core.appid.RequestSettings;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.requestparam.PhotonRequestParameters;
import com.helger.photon.core.requestparam.RequestParameterManager;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.filter.IXServletHighLevelFilter;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Locale;

public final class XServletFilterAppIDExplicit
implements IXServletHighLevelFilter {
    private final String m_sAppID;

    public XServletFilterAppIDExplicit(@Nonnull @Nonempty String string) {
        this.m_sAppID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"AppID");
    }

    public static void setStatePerApp(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        Locale locale;
        Serializable serializable;
        PhotonSessionState photonSessionState = PhotonSessionState.getInstance();
        photonSessionState.setLastApplicationID(string);
        PhotonSessionStatePerApp photonSessionStatePerApp = photonSessionState.state(string);
        PhotonGlobalStatePerApp photonGlobalStatePerApp = PhotonGlobalState.state(string);
        IMenuTree iMenuTree = photonSessionStatePerApp.getMenuTree();
        if (iMenuTree == null && (iMenuTree = photonGlobalStatePerApp.getMenuTree()) != null) {
            photonSessionStatePerApp.setMenuTree(iMenuTree);
        }
        if (iMenuTree == null) {
            throw new IllegalStateException("Failed to resolve MenuTree for request using application ID '" + string + "'!");
        }
        PhotonRequestParameters photonRequestParameters = RequestParameterManager.getInstance().getParameterHandler().getParametersFromRequest(iRequestWebScopeWithoutResponse, iMenuTree);
        Serializable serializable2 = photonRequestParameters.getMenuItem();
        if (serializable2 == null && (serializable2 = photonSessionStatePerApp.getMenuItem()) == null) {
            IMenuItemPage iMenuItemPage;
            serializable = iMenuTree.getDefaultMenuItem();
            if (serializable != null && serializable.matchesDisplayFilter()) {
                serializable2 = serializable;
            }
            if (serializable2 == null && (locale = (DefaultTreeItemWithID)iMenuTree.getRootItem()).hasChildren() && (iMenuItemPage = (IMenuItemPage)locale.findFirstChildMapped(defaultTreeItemWithID -> defaultTreeItemWithID.getData() instanceof IMenuItemPage && ((IMenuObject)defaultTreeItemWithID.getData()).matchesDisplayFilter(), defaultTreeItemWithID -> (IMenuItemPage)defaultTreeItemWithID.getData())) != null) {
                serializable2 = iMenuItemPage;
            }
        }
        if (serializable2 == null) {
            throw new IllegalStateException("No menu item is present for application ID '" + string + "'!");
        }
        photonSessionStatePerApp.setMenuItem((IMenuItemPage)serializable2);
        serializable = photonRequestParameters.getLocale();
        if (serializable == null) {
            locale = photonSessionStatePerApp.getDisplayLocale();
            if (locale != null) {
                serializable = locale;
            }
            if (serializable == null && (serializable = GlobalLocaleManager.getInstance().getDefaultLocale()) == null) {
                throw new IllegalStateException("No locale could be determined for application ID '" + string + "!");
            }
        }
        photonSessionStatePerApp.setDisplayLocale((Locale)serializable);
        RequestSettings.setRequestState(iRequestWebScopeWithoutResponse, string, new PhotonRequestState(iMenuTree, (IMenuItemPage)serializable2, (Locale)serializable));
    }

    public void beforeRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        XServletFilterAppIDExplicit.setStatePerApp((IRequestWebScopeWithoutResponse)iRequestWebScope, this.m_sAppID);
    }

    public void afterRequest(@Nonnull IRequestWebScope iRequestWebScope) {
    }
}

