/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuTree;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Locale;

@ThreadSafe
public final class PhotonSessionStatePerApp
implements Serializable {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private IMenuTree m_aMenuTree;
    private IMenuItemPage m_aMenuItem;
    private Locale m_aDisplayLocale;

    @Nullable
    public IMenuTree getMenuTree() {
        return (IMenuTree)this.m_aRWLock.readLockedGet(() -> this.m_aMenuTree);
    }

    @Nonnull
    public PhotonSessionStatePerApp setMenuTree(@Nullable IMenuTree iMenuTree) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMenuTree = iMenuTree;
        });
        return this;
    }

    @Nullable
    public IMenuItemPage getMenuItem() {
        return (IMenuItemPage)this.m_aRWLock.readLockedGet(() -> this.m_aMenuItem);
    }

    @Nonnull
    public PhotonSessionStatePerApp setMenuItem(@Nullable IMenuItemPage iMenuItemPage) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMenuItem = iMenuItemPage;
        });
        return this;
    }

    @Nullable
    public Locale getDisplayLocale() {
        return (Locale)this.m_aRWLock.readLockedGet(() -> this.m_aDisplayLocale);
    }

    @Nonnull
    public PhotonSessionStatePerApp setDisplayLocale(@Nullable Locale locale) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aDisplayLocale = locale;
        });
        return this;
    }

    public boolean isNotEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMenuTree != null || this.m_aMenuItem != null || this.m_aDisplayLocale != null);
    }

    public String toString() {
        return new ToStringGenerator(null).append("MenuTree", (Object)this.m_aMenuTree).append("MenuItem", (Object)this.m_aMenuItem).append("DisplayLocale", (Object)this.m_aDisplayLocale).getToString();
    }
}

