/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.photon.core.appid.PhotonSessionStatePerApp;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@ThreadSafe
public final class PhotonSessionState
extends AbstractSessionWebSingleton {
    @GuardedBy(value="RW_LOCK")
    private String m_sLastApplicationID;
    private final ICommonsMap<String, PhotonSessionStatePerApp> m_aStateMap = new CommonsHashMap();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public PhotonSessionState() {
    }

    @Nonnull
    public static PhotonSessionState getInstance() {
        return (PhotonSessionState)PhotonSessionState.getSessionSingleton(PhotonSessionState.class);
    }

    @Nullable
    public static PhotonSessionState getInstanceIfInstantiated() {
        return (PhotonSessionState)PhotonSessionState.getSessionSingletonIfInstantiated(PhotonSessionState.class);
    }

    @Nullable
    public String getLastApplicationID() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sLastApplicationID);
    }

    void setLastApplicationID(@Nullable String string) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_sLastApplicationID = string;
        });
    }

    @Nonnull
    public PhotonSessionStatePerApp state(@Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"AppID");
        return (PhotonSessionStatePerApp)this.m_aStateMap.computeIfAbsent((Object)string2, string -> new PhotonSessionStatePerApp());
    }

    @Nonnull
    public PhotonSessionStatePerApp stateLastAppID() {
        return this.state(this.getLastApplicationID());
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("LastApplicationID", (Object)this.m_sLastApplicationID).append("StateMap", this.m_aStateMap).getToString();
    }
}

