/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.core.menu.IMenuTree;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

@ThreadSafe
public final class PhotonGlobalStatePerApp
implements Serializable {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private String m_sServletPath;
    @GuardedBy(value="m_aRWLock")
    private IMenuTree m_aMenuTree;

    @Nullable
    String internalGetServletPath() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sServletPath);
    }

    @Nonnull
    @Nonempty
    public String getServletPath() throws IllegalStateException {
        String string = this.internalGetServletPath();
        if (StringHelper.isEmpty((String)string)) {
            throw new IllegalStateException("No servlet path specified!");
        }
        return string;
    }

    @Nonnull
    public PhotonGlobalStatePerApp setServletPath(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ApplicationServletPath");
        ValueEnforcer.isTrue((boolean)StringHelper.startsWith((CharSequence)string, (char)'/'), (String)"ApplicationServletPath must start with a slash");
        ValueEnforcer.isFalse((boolean)StringHelper.endsWith((CharSequence)string, (char)'/'), (String)"ApplicationServletPath must end with a slash");
        this.m_aRWLock.writeLocked(() -> {
            this.m_sServletPath = string;
        });
        return this;
    }

    @Nonnull
    public PhotonGlobalStatePerApp removeServletPath() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_sServletPath = null;
        });
        return this;
    }

    @Nullable
    public IMenuTree getMenuTree() {
        return (IMenuTree)this.m_aRWLock.readLockedGet(() -> this.m_aMenuTree);
    }

    @Nonnull
    public PhotonGlobalStatePerApp setMenuTree(@Nullable IMenuTree iMenuTree) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMenuTree = iMenuTree;
        });
        return this;
    }

    public String toString() {
        return new ToStringGenerator(null).append("ServletPath", (Object)this.m_sServletPath).append("MenuTree", (Object)this.m_aMenuTree).getToString();
    }
}

