/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.photon.core.appid.PhotonGlobalStatePerApp;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhotonGlobalState
extends AbstractGlobalWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonGlobalState.class);
    private String m_sDefaultApplicationID;
    private final ICommonsMap<String, PhotonGlobalStatePerApp> m_aStateMap = new CommonsHashMap();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public PhotonGlobalState() {
    }

    @Nonnull
    public static PhotonGlobalState getInstance() {
        return (PhotonGlobalState)PhotonGlobalState.getGlobalSingleton(PhotonGlobalState.class);
    }

    @Nullable
    public String getDefaultApplicationID() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sDefaultApplicationID);
    }

    public boolean hasDefaultApplicationID() {
        return StringHelper.isNotEmpty((String)this.getDefaultApplicationID());
    }

    @Nonnull
    public PhotonGlobalState setDefaultApplicationID(@Nullable String string) {
        this.m_aRWLock.writeLocked(() -> {
            if (!EqualsHelper.equals((Object)this.m_sDefaultApplicationID, (Object)string)) {
                this.m_sDefaultApplicationID = string;
                LOGGER.info("Default application ID set to '" + string + "'");
            }
        });
        return this;
    }

    @Nonnull
    public static PhotonGlobalStatePerApp state(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AppID");
        PhotonGlobalState photonGlobalState = PhotonGlobalState.getInstance();
        return (PhotonGlobalStatePerApp)photonGlobalState.m_aStateMap.computeIfAbsent((Object)string, string2 -> {
            if (!photonGlobalState.hasDefaultApplicationID()) {
                photonGlobalState.setDefaultApplicationID(string);
            }
            return new PhotonGlobalStatePerApp();
        });
    }

    public static void clear() {
        PhotonGlobalState photonGlobalState = PhotonGlobalState.getInstance();
        photonGlobalState.m_aStateMap.clear();
        photonGlobalState.setDefaultApplicationID(null);
    }

    public static void removeAllApplicationServletPathMappings() {
        PhotonGlobalState.getInstance().m_aStateMap.forEachValue(PhotonGlobalStatePerApp::removeServletPath);
    }

    public static boolean containsNoState() {
        return PhotonGlobalState.getInstance().m_aStateMap.isEmpty();
    }

    public static boolean containsAnyApplicationServletPathMapping() {
        return PhotonGlobalState.getInstance().m_aStateMap.containsAnyValue(photonGlobalStatePerApp -> photonGlobalStatePerApp.internalGetServletPath() != null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> getAppIDToServletPathMap() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        PhotonGlobalState.getInstance().m_aStateMap.forEach((arg_0, arg_1) -> PhotonGlobalState.lambda$getAppIDToServletPathMap$4((ICommonsMap)commonsHashMap, arg_0, arg_1));
        return commonsHashMap;
    }

    private static /* synthetic */ void lambda$getAppIDToServletPathMap$4(ICommonsMap iCommonsMap, String string, PhotonGlobalStatePerApp photonGlobalStatePerApp) {
        iCommonsMap.put((Object)string, (Object)photonGlobalStatePerApp.getServletPath());
    }
}

