/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.ajax.atom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.timing.StopWatch;
import com.helger.mime.CMimeType;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.photon.atom.Feed;
import com.helger.photon.atom.FeedGenerator;
import com.helger.photon.atom.FeedLink;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.text.display.IHasDisplayText;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xml.microdom.IMicroNode;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNewsfeedAjaxExecutor
implements IAjaxExecutor,
IHasID<String>,
IHasDisplayText {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNewsfeedAjaxExecutor.class);
    private static final IMutableStatisticsHandlerKeyedCounter STATS_HDL_EXECUTE = StatisticsManager.getKeyedCounterHandler((String)(AbstractNewsfeedAjaxExecutor.class.getName() + "$EXECUTE"));
    private static final IMutableStatisticsHandlerKeyedCounter STATS_HDL_ERROR = StatisticsManager.getKeyedCounterHandler((String)(AbstractNewsfeedAjaxExecutor.class.getName() + "$ERROR"));
    private final IHasDisplayText m_aDisplayText;
    private final String m_sFeedID;

    public AbstractNewsfeedAjaxExecutor(@Nonnull IHasDisplayText iHasDisplayText, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)iHasDisplayText, (String)"DisplayText");
        ValueEnforcer.notNull((Object)string, (String)"FeedID");
        this.m_aDisplayText = iHasDisplayText;
        this.m_sFeedID = string;
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sFeedID;
    }

    public final String getDisplayText(@Nonnull Locale locale) {
        return this.m_aDisplayText.getDisplayText(locale);
    }

    @Nonnull
    @OverrideOnDemand
    protected String getFeedDescription() {
        return "ph-oton-core";
    }

    protected abstract void fillNewsfeed(@Nonnull Feed var1);

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull PhotonUnifiedResponse photonUnifiedResponse) throws Exception {
        StopWatch stopWatch = StopWatch.createdStarted();
        STATS_HDL_EXECUTE.increment(this.m_sFeedID);
        Feed feed = new Feed();
        feed.setID("urn:ph-oton-core:newsfeed:" + this.m_sFeedID);
        FeedGenerator feedGenerator = new FeedGenerator("urn:ph-oton-core");
        feedGenerator.setDescription(this.getFeedDescription());
        feed.setGenerator(feedGenerator);
        feed.addLink(new FeedLink(iRequestWebScopeWithoutResponse.getFullContextAndServletPath() + this.m_sFeedID, "self"));
        this.fillNewsfeed(feed);
        if (!feed.isValid()) {
            LOGGER.error("Created newsfeed with ID '" + this.m_sFeedID + "' is invalid!");
            STATS_HDL_ERROR.increment(this.m_sFeedID);
        }
        LocalDateTime localDateTime = feed.getUpdated() != null ? feed.getUpdated().getDateTime() : null;
        StatisticsManager.getTimerHandler((String)(AbstractNewsfeedAjaxExecutor.class.getName() + "$TIMER." + this.m_sFeedID)).addTime(stopWatch.stopAndGetMillis());
        photonUnifiedResponse.xml((IMicroNode)feed.getAsDocument());
        photonUnifiedResponse.setMimeType(CMimeType.APPLICATION_ATOM_XML);
        if (localDateTime != null) {
            photonUnifiedResponse.setLastModified(localDateTime);
        }
    }
}

