/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.callback.ICallback;
import com.helger.photon.app.PhotonAppInit;
import com.helger.photon.core.audit.AuditingLongRunningRequestCallback;
import com.helger.photon.core.audit.AuditingParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.RequestTracker;
import java.util.concurrent.atomic.AtomicBoolean;

@Immutable
public final class PhotonCoreInit {
    private static final AtomicBoolean REGISTERED_REQUEST_TRACKER = new AtomicBoolean(false);

    private PhotonCoreInit() {
    }

    public static void startUp() {
        PhotonAppInit.startUp();
        if (!REGISTERED_REQUEST_TRACKER.getAndSet(true)) {
            RequestTracker.longRunningRequestCallbacks().add((ICallback)AuditingLongRunningRequestCallback.INSTANCE);
            RequestTracker.parallelRunningRequestCallbacks().add((ICallback)AuditingParallelRunningRequestCallback.INSTANCE);
        }
    }

    public static void shutdown() {
        if (REGISTERED_REQUEST_TRACKER.getAndSet(false)) {
            RequestTracker.longRunningRequestCallbacks().removeObject((ICallback)AuditingLongRunningRequestCallback.INSTANCE);
            RequestTracker.parallelRunningRequestCallbacks().removeObject((ICallback)AuditingParallelRunningRequestCallback.INSTANCE);
        }
        PhotonAppInit.shutdown();
    }
}

