/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.utils;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.css.ICSSClassProvider;
import com.helger.photon.bootstrap4.grid.EBootstrapGridType;
import com.helger.photon.bootstrap4.utils.EBootstrapSpacingPropertyType;
import com.helger.photon.bootstrap4.utils.EBootstrapSpacingSideType;
import jakarta.annotation.Nonnull;
import java.io.Serializable;

public class BootstrapSpacingBuilder
implements ICSSClassProvider,
Serializable {
    private EBootstrapSpacingPropertyType m_eProperty = EBootstrapSpacingPropertyType.MARGIN;
    private EBootstrapSpacingSideType m_eSide = EBootstrapSpacingSideType.ALL;
    private EBootstrapGridType m_eGrid = EBootstrapGridType.XS;
    private int m_nSize = -1;

    @Nonnull
    public BootstrapSpacingBuilder property(@Nonnull EBootstrapSpacingPropertyType eBootstrapSpacingPropertyType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapSpacingPropertyType), (String)"Property");
        this.m_eProperty = eBootstrapSpacingPropertyType;
        return this;
    }

    @Nonnull
    public BootstrapSpacingBuilder side(@Nonnull EBootstrapSpacingSideType eBootstrapSpacingSideType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapSpacingSideType), (String)"Side");
        this.m_eSide = eBootstrapSpacingSideType;
        return this;
    }

    @Nonnull
    public BootstrapSpacingBuilder grid(@Nonnull EBootstrapGridType eBootstrapGridType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapGridType), (String)"Grid");
        this.m_eGrid = eBootstrapGridType;
        return this;
    }

    @Nonnull
    public BootstrapSpacingBuilder size(int n) {
        ValueEnforcer.isBetweenInclusive((int)n, (String)"Size", (int)0, (int)5);
        this.m_nSize = n;
        return this;
    }

    @Nonnull
    public BootstrapSpacingBuilder sizeAuto() {
        this.m_nSize = -1;
        return this;
    }

    @Nonnull
    public String getCSSClass() {
        String string = this.m_eProperty.getCSSClassNamePart() + this.m_eSide.getCSSClassNamePart() + this.m_eGrid.getCSSClassNamePart() + "-";
        string = this.m_nSize == -1 ? string + "auto" : string + this.m_nSize;
        return string;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static BootstrapSpacingBuilder createMarginBuilder() {
        return new BootstrapSpacingBuilder().property(EBootstrapSpacingPropertyType.MARGIN);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static BootstrapSpacingBuilder createPaddingBuilder() {
        return new BootstrapSpacingBuilder().property(EBootstrapSpacingPropertyType.PADDING);
    }
}

