/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.tooltip;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.EHTMLElement;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.script.HCScriptInlineOnDocumentReady;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.jquery.IJQuerySelector;
import com.helger.html.jquery.JQuerySelector;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSInvocation;
import com.helger.photon.bootstrap4.tooltip.EBootstrapTooltipBoundary;
import com.helger.photon.bootstrap4.tooltip.EBootstrapTooltipFallbackPlacement;
import com.helger.photon.bootstrap4.tooltip.EBootstrapTooltipPosition;
import com.helger.photon.bootstrap4.tooltip.EBootstrapTooltipTrigger;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Set;

@OutOfBandNode
public class BootstrapTooltip
extends HCScriptInlineOnDocumentReady {
    public static final String JS_EVENT_SHOW = "show.bs.tooltip";
    public static final String JS_EVENT_SHOWN = "shown.bs.tooltip";
    public static final String JS_EVENT_HIDE = "hide.bs.tooltip";
    public static final String JS_EVENT_HIDDEN = "hidden.bs.tooltip";
    public static final String JS_EVENT_INSERTED = "inserted.bs.tooltip";
    public static final boolean DEFAULT_ANIMATION = true;
    public static final boolean DEFAULT_HTML = false;
    public static final EBootstrapTooltipPosition DEFAULT_PLACEMENT = EBootstrapTooltipPosition.TOP;
    @CodingStyleguideUnaware
    public static final Set<EBootstrapTooltipTrigger> DEFAULT_TRIGGER = new CommonsLinkedHashSet((Object[])new EBootstrapTooltipTrigger[]{EBootstrapTooltipTrigger.HOVER, EBootstrapTooltipTrigger.FOCUS}).getAsUnmodifiable();
    public static final EBootstrapTooltipFallbackPlacement DEFAULT_FALLBACK_PLACEMENT = EBootstrapTooltipFallbackPlacement.FLIP;
    public static final EBootstrapTooltipBoundary DEFAULT_BOUNDARY = EBootstrapTooltipBoundary.SCROLL_PARENT;
    private final IJQuerySelector m_aSelector;
    private boolean m_bAnimation = true;
    private IJQuerySelector m_aContainer;
    private int m_nDelayShow = 0;
    private int m_nDelayHide = 0;
    private boolean m_bHTML = false;
    private EBootstrapTooltipPosition m_ePlacement = DEFAULT_PLACEMENT;
    private JSAnonymousFunction m_aPlacementFunc;
    private String m_sSelector;
    private String m_sTooltipTitle;
    private JSAnonymousFunction m_aTooltipTitleFunc;
    @CodingStyleguideUnaware
    private Set<EBootstrapTooltipTrigger> m_aTrigger = DEFAULT_TRIGGER;
    private String m_sOffset;
    private EBootstrapTooltipFallbackPlacement m_eFallbackPlacement = DEFAULT_FALLBACK_PLACEMENT;
    private EBootstrapTooltipBoundary m_eBoundary = DEFAULT_BOUNDARY;

    public BootstrapTooltip(@Nonnull IHCElement<?> iHCElement) {
        this(JQuerySelector.id(iHCElement));
    }

    public BootstrapTooltip(@Nonnull IJQuerySelector iJQuerySelector) {
        ValueEnforcer.notNull((Object)iJQuerySelector, (String)"Selector");
        this.m_aSelector = iJQuerySelector;
    }

    public boolean isAnimation() {
        return this.m_bAnimation;
    }

    @Nonnull
    public BootstrapTooltip setAnimation(boolean bl) {
        this.m_bAnimation = bl;
        return this;
    }

    public boolean isHTML() {
        return this.m_bHTML;
    }

    @Nonnull
    public BootstrapTooltip setHTML(boolean bl) {
        this.m_bHTML = bl;
        return this;
    }

    @Nullable
    public EBootstrapTooltipPosition getPlacementPosition() {
        return this.m_ePlacement;
    }

    @Nullable
    public JSAnonymousFunction getPlacementFunction() {
        return this.m_aPlacementFunc;
    }

    @Nonnull
    public BootstrapTooltip setPlacement(@Nonnull EBootstrapTooltipPosition eBootstrapTooltipPosition) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapTooltipPosition), (String)"Position");
        this.m_ePlacement = eBootstrapTooltipPosition;
        this.m_aPlacementFunc = null;
        return this;
    }

    @Nonnull
    public BootstrapTooltip setPlacement(@Nonnull JSAnonymousFunction jSAnonymousFunction) {
        ValueEnforcer.notNull((Object)jSAnonymousFunction, (String)"Function");
        this.m_ePlacement = null;
        this.m_aPlacementFunc = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public String getSelector() {
        return this.m_sSelector;
    }

    @Nonnull
    public BootstrapTooltip setSelector(@Nullable String string) {
        this.m_sSelector = string;
        return this;
    }

    @Nullable
    public String getTooltipTitleString() {
        return this.m_sTooltipTitle;
    }

    @Nullable
    public JSAnonymousFunction getTooltipTitleFunction() {
        return this.m_aTooltipTitleFunc;
    }

    @Nonnull
    public BootstrapTooltip setTooltipTitle(@Nullable String string) {
        this.m_sTooltipTitle = string;
        this.m_aTooltipTitleFunc = null;
        return this;
    }

    @Nonnull
    public BootstrapTooltip setTooltipTitle(@Nullable IHCNode iHCNode) {
        this.setHTML(true);
        this.m_sTooltipTitle = iHCNode == null ? null : HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode);
        this.m_aTooltipTitleFunc = null;
        return this;
    }

    @Nonnull
    public BootstrapTooltip setTooltipTitle(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_sTooltipTitle = null;
        this.m_aTooltipTitleFunc = jSAnonymousFunction;
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<EBootstrapTooltipTrigger> getTrigger() {
        return new CommonsArrayList(this.m_aTrigger);
    }

    @Nonnull
    public BootstrapTooltip setTrigger(EBootstrapTooltipTrigger ... eBootstrapTooltipTriggerArray) {
        this.m_aTrigger = new CommonsTreeSet((Object[])eBootstrapTooltipTriggerArray);
        return this;
    }

    @Nonnull
    public BootstrapTooltip setTrigger(@Nullable Collection<EBootstrapTooltipTrigger> collection) {
        this.m_aTrigger = new CommonsTreeSet(collection);
        return this;
    }

    @Nonnegative
    public int getDelayShow() {
        return this.m_nDelayShow;
    }

    @Nonnegative
    public int getDelayHide() {
        return this.m_nDelayHide;
    }

    @Nonnull
    public BootstrapTooltip setDelay(@Nonnegative int n) {
        return this.setDelay(n, n);
    }

    @Nonnull
    public BootstrapTooltip setDelay(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGE0((int)n, (String)"ShowDelay");
        ValueEnforcer.isGE0((int)n2, (String)"HideDelay");
        this.m_nDelayShow = n;
        this.m_nDelayHide = n2;
        return this;
    }

    @Nullable
    public IJQuerySelector getContainer() {
        return this.m_aContainer;
    }

    @Nonnull
    public BootstrapTooltip setContainer(@Nonnull EHTMLElement eHTMLElement) {
        ValueEnforcer.notNull((Object)eHTMLElement, (String)"Container");
        return this.setContainer(JQuerySelector.element((EHTMLElement)eHTMLElement));
    }

    @Nonnull
    public BootstrapTooltip setContainer(@Nullable IJQuerySelector iJQuerySelector) {
        this.m_aContainer = iJQuerySelector;
        return this;
    }

    @Nullable
    public String getOffset() {
        return this.m_sOffset;
    }

    @Nonnull
    public BootstrapTooltip setOffset(@Nullable String string) {
        this.m_sOffset = string;
        return this;
    }

    @Nonnull
    public BootstrapTooltip setOffset(int n) {
        return this.setOffset(Integer.toString(n));
    }

    @Nullable
    public EBootstrapTooltipFallbackPlacement getFallbackPlacement() {
        return this.m_eFallbackPlacement;
    }

    @Nonnull
    public BootstrapTooltip setFallbackPlacement(@Nullable EBootstrapTooltipFallbackPlacement eBootstrapTooltipFallbackPlacement) {
        this.m_eFallbackPlacement = eBootstrapTooltipFallbackPlacement;
        return this;
    }

    @Nullable
    public EBootstrapTooltipBoundary getBoundary() {
        return this.m_eBoundary;
    }

    @Nonnull
    public BootstrapTooltip setBoundary(@Nullable EBootstrapTooltipBoundary eBootstrapTooltipBoundary) {
        this.m_eBoundary = eBootstrapTooltipBoundary;
        return this;
    }

    @Nonnull
    public JSAssocArray getJSOptions() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (!this.m_bAnimation) {
            jSAssocArray.add("animation", this.m_bAnimation);
        }
        if (this.m_aContainer != null) {
            jSAssocArray.add("container", this.m_aContainer.getExpression());
        }
        if (this.m_nDelayShow > 0 || this.m_nDelayHide > 0) {
            if (this.m_nDelayShow == this.m_nDelayHide) {
                jSAssocArray.add("delay", this.m_nDelayShow);
            } else {
                jSAssocArray.add("delay", (IJSExpression)new JSAssocArray().add("show", this.m_nDelayShow).add("hide", this.m_nDelayHide));
            }
        }
        if (this.m_bHTML) {
            jSAssocArray.add("html", this.m_bHTML);
        }
        if (this.m_ePlacement != null) {
            jSAssocArray.add("placement", this.m_ePlacement.getValue());
        } else {
            jSAssocArray.add("placement", (IJSExpression)this.m_aPlacementFunc);
        }
        if (StringHelper.isNotEmpty((String)this.m_sSelector)) {
            jSAssocArray.add("selector", this.m_sSelector);
        }
        if (StringHelper.isNotEmpty((String)this.m_sTooltipTitle)) {
            jSAssocArray.add("title", this.m_sTooltipTitle);
        } else if (this.m_aTooltipTitleFunc != null) {
            jSAssocArray.add("title", (IJSExpression)this.m_aTooltipTitleFunc);
        }
        if (!this.m_aTrigger.isEmpty() && !DEFAULT_TRIGGER.equals(this.m_aTrigger)) {
            jSAssocArray.add("trigger", StringImplode.getImplodedMapped((char)' ', this.m_aTrigger, EBootstrapTooltipTrigger::getValue));
        }
        if (StringHelper.isNotEmpty((String)this.m_sOffset)) {
            jSAssocArray.add("offset", this.m_sOffset);
        }
        if (this.m_eBoundary != null) {
            jSAssocArray.add("boundary", this.m_eBoundary.getValue());
        }
        return jSAssocArray;
    }

    @Nonnull
    public JSInvocation jsInvoke() {
        return this.m_aSelector.invoke().invoke("tooltip");
    }

    @Nonnull
    public JSInvocation jsAttach() {
        return (JSInvocation)this.jsInvoke().arg((IJSExpression)this.getJSOptions());
    }

    @Nonnull
    public JSInvocation jsShow() {
        return (JSInvocation)this.jsInvoke().arg("show");
    }

    @Nonnull
    public JSInvocation jsHide() {
        return (JSInvocation)this.jsInvoke().arg("hide");
    }

    @Nonnull
    public JSInvocation jsToggle() {
        return (JSInvocation)this.jsInvoke().arg("toggle");
    }

    @Nonnull
    public JSInvocation jsDispose() {
        return (JSInvocation)this.jsInvoke().arg("dispose");
    }

    @Nonnull
    public JSInvocation jsEnable() {
        return (JSInvocation)this.jsInvoke().arg("enable");
    }

    @Nonnull
    public JSInvocation jsDisable() {
        return (JSInvocation)this.jsInvoke().arg("disable");
    }

    @Nonnull
    public JSInvocation jsToggleEnabled() {
        return (JSInvocation)this.jsInvoke().arg("toggleEnabled");
    }

    @Nonnull
    public JSInvocation jsUpdate() {
        return (JSInvocation)this.jsInvoke().arg("update");
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.setOnDocumentReadyCode((IHasJSCode)this.jsAttach());
    }
}

