/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.navbar;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.sections.AbstractHCNav;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.html.textlevel.HCSpan;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.navbar.BootstrapNavbarNav;
import com.helger.photon.bootstrap4.navbar.BootstrapNavbarText;
import com.helger.photon.bootstrap4.navbar.BootstrapNavbarToggleable;
import com.helger.photon.bootstrap4.navbar.BootstrapNavbarToggler;
import com.helger.photon.bootstrap4.navbar.EBootstrapNavbarColorSchemeType;
import com.helger.photon.bootstrap4.navbar.EBootstrapNavbarExpandType;
import com.helger.photon.bootstrap4.utils.EBootstrapBackgroundType;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BootstrapNavbar
extends AbstractHCNav<BootstrapNavbar> {
    public static final EBootstrapNavbarColorSchemeType DEFAULT_COLOR_SCHEME = EBootstrapNavbarColorSchemeType.LIGHT;
    public static final EBootstrapNavbarExpandType DEFAULT_EXPAND = EBootstrapNavbarExpandType.EXPAND_MD;
    public static final EBootstrapBackgroundType DEFAULT_BACKGROUND = EBootstrapBackgroundType.LIGHT;
    private EBootstrapNavbarColorSchemeType m_eColorScheme = DEFAULT_COLOR_SCHEME;
    private EBootstrapNavbarExpandType m_eExpand = DEFAULT_EXPAND;
    private EBootstrapBackgroundType m_eBackground = DEFAULT_BACKGROUND;

    @Nonnull
    public final EBootstrapNavbarColorSchemeType getColorScheme() {
        return this.m_eColorScheme;
    }

    @Nonnull
    public final BootstrapNavbar setColorScheme(@Nonnull EBootstrapNavbarColorSchemeType eBootstrapNavbarColorSchemeType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapNavbarColorSchemeType), (String)"ColorScheme");
        this.m_eColorScheme = eBootstrapNavbarColorSchemeType;
        return this;
    }

    @Nonnull
    public final EBootstrapNavbarExpandType getExpand() {
        return this.m_eExpand;
    }

    @Nonnull
    public final BootstrapNavbar setExpand(@Nonnull EBootstrapNavbarExpandType eBootstrapNavbarExpandType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapNavbarExpandType), (String)"Expand");
        this.m_eExpand = eBootstrapNavbarExpandType;
        return this;
    }

    @Nullable
    public final EBootstrapBackgroundType getBackground() {
        return this.m_eBackground;
    }

    @Nonnull
    public final BootstrapNavbar setBackground(@Nullable EBootstrapBackgroundType eBootstrapBackgroundType) {
        this.m_eBackground = eBootstrapBackgroundType;
        return this;
    }

    @Nonnull
    public static IHCElementWithChildren<?> createBrand(@Nonnull IHCNode iHCNode, @Nullable ISimpleURL iSimpleURL) {
        IHCElementWithChildren iHCElementWithChildren = iSimpleURL != null ? (IHCElementWithChildren)((HCA)new HCA().setHref(iSimpleURL)).addChild(iHCNode) : (iHCNode instanceof IHCElementWithChildren ? (IHCElementWithChildren)iHCNode : (IHCElementWithChildren)new HCSpan().addChild(iHCNode));
        iHCElementWithChildren.addClass(CBootstrapCSS.NAVBAR_BRAND);
        return iHCElementWithChildren;
    }

    @Nonnull
    public final BootstrapNavbar addBrand(@Nonnull IHCNode iHCNode, @Nullable ISimpleURL iSimpleURL) {
        this.addChild((IHCNode)BootstrapNavbar.createBrand(iHCNode, iSimpleURL));
        return this;
    }

    @Nonnull
    public final BootstrapNavbar addToggler(@Nonnull @Nonempty String string) {
        this.addChild((IHCNode)new BootstrapNavbarToggler(string));
        return this;
    }

    @Nonnull
    public BootstrapNavbarToggleable addAndReturnToggleable() {
        String string = GlobalIDFactory.getNewStringID();
        this.addToggler(string);
        return this.addAndReturnToggleable(string);
    }

    @Nonnull
    public BootstrapNavbarToggleable addAndReturnToggleable(@Nonnull @Nonempty String string) {
        BootstrapNavbarToggleable bootstrapNavbarToggleable = (BootstrapNavbarToggleable)new BootstrapNavbarToggleable().setID(string);
        return (BootstrapNavbarToggleable)this.addAndReturnChild((IHCNode)bootstrapNavbarToggleable);
    }

    @Nonnull
    public BootstrapNavbarText addAndReturnText() {
        return (BootstrapNavbarText)this.addAndReturnChild((IHCNode)new BootstrapNavbarText());
    }

    @Nonnull
    public BootstrapNavbarNav addAndReturnNav() {
        return (BootstrapNavbarNav)this.addAndReturnChild((IHCNode)new BootstrapNavbarNav());
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClass(CBootstrapCSS.NAVBAR);
        this.addClass(this.m_eColorScheme);
        this.addClass(this.m_eExpand);
        this.addClass(this.m_eBackground);
    }
}

