/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.nav;

import com.helger.base.string.StringHelper;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.nav.BootstrapNav;
import com.helger.photon.bootstrap4.nav.BootstrapNavItem;
import com.helger.photon.bootstrap4.nav.EBootstrapNavType;
import com.helger.photon.uicore.html.tabbox.AbstractTabBox;
import com.helger.photon.uicore.html.tabbox.Tab;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BootstrapTabBox
extends AbstractTabBox<BootstrapTabBox> {
    public static final String JS_EVENT_SHOW = "show.bs.tab";
    public static final String JS_EVENT_SHOWN = "shown.bs.tab";
    public static final String JS_EVENT_HIDE = "hide.bs.tab";
    public static final String JS_EVENT_HIDDEN = "hidden.bs.tab";
    private String m_sNavID;

    @Nullable
    public final String getNavID() {
        return this.m_sNavID;
    }

    @Nonnull
    public final BootstrapTabBox setNavID(@Nullable String string) {
        this.m_sNavID = string;
        return this;
    }

    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return !this.m_aTabs.isEmpty();
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        String string = this.getActiveTabID();
        if (StringHelper.isEmpty((String)string)) {
            string = (String)this.m_aTabs.getFirstKey();
        }
        BootstrapNav bootstrapNav = new BootstrapNav(EBootstrapNavType.TABS);
        bootstrapNav.setID(this.m_sNavID);
        HCDiv hCDiv = (HCDiv)new HCDiv().addClass(CBootstrapCSS.TAB_CONTENT);
        for (Tab tab : this.m_aTabs.values()) {
            boolean bl = tab.getID().equals(string);
            BootstrapNavItem bootstrapNavItem = (BootstrapNavItem)bootstrapNav.addItem();
            HCA hCA = (HCA)((HCA)new HCA(tab.getLinkURL()).addChild(tab.getLabel())).addClass(CBootstrapCSS.NAV_LINK);
            if (bl) {
                hCA.addClass(CBootstrapCSS.ACTIVE);
            }
            if (tab.isDisabled()) {
                bootstrapNavItem.addClass(CBootstrapCSS.DISABLED);
            } else {
                hCA.customAttrs().setDataAttr("toggle", "tab");
            }
            bootstrapNavItem.addChild((IHCNode)hCA);
            HCDiv hCDiv2 = (HCDiv)hCDiv.addAndReturnChild((IHCNode)((HCDiv)((HCDiv)((HCDiv)new HCDiv().addChild(tab.getContent())).addClass(CBootstrapCSS.TAB_PANE)).setID(tab.getID())));
            if (!bl) continue;
            hCDiv2.addClass(CBootstrapCSS.ACTIVE);
        }
        this.addChild((IHCNode)bootstrapNav);
        this.addChild((IHCNode)hCDiv);
    }
}

