/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.nav;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.AbstractHCULBase;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.nav.BootstrapNavItem;
import com.helger.photon.bootstrap4.nav.EBootstrapNavType;
import jakarta.annotation.Nonnull;

public class BootstrapNav
extends AbstractHCULBase<BootstrapNav, BootstrapNavItem> {
    public static final boolean DEFAULT_FILL = false;
    public static final boolean DEFAULT_JUSTIFY = false;
    private EBootstrapNavType m_eNavType;
    private boolean m_bFill = false;
    private boolean m_bJustified = false;

    public BootstrapNav() {
        this(EBootstrapNavType.DEFAULT);
    }

    public BootstrapNav(@Nonnull EBootstrapNavType eBootstrapNavType) {
        super(BootstrapNavItem.class);
        this.setType(eBootstrapNavType);
    }

    protected final BootstrapNavItem createEmptyItem() {
        return new BootstrapNavItem();
    }

    @Nonnull
    public final EBootstrapNavType getNavType() {
        return this.m_eNavType;
    }

    @Nonnull
    public final BootstrapNav setType(@Nonnull EBootstrapNavType eBootstrapNavType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapNavType), (String)"NavType");
        this.m_eNavType = eBootstrapNavType;
        return this;
    }

    public final boolean isFill() {
        return this.m_bFill;
    }

    @Nonnull
    public final BootstrapNav setFill(boolean bl) {
        this.m_bFill = bl;
        return this;
    }

    public final boolean isJustified() {
        return this.m_bJustified;
    }

    @Nonnull
    public final BootstrapNav setJustified(boolean bl) {
        this.m_bJustified = bl;
        return this;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClass(CBootstrapCSS.NAV);
        this.addClass(this.m_eNavType.getCSSClass());
        if (this.m_bFill) {
            this.addClass(CBootstrapCSS.NAV_FILL);
        }
        if (this.m_bJustified) {
            this.addClass(CBootstrapCSS.NAV_JUSTIFIED);
        }
    }
}

