/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.grid;

import com.helger.annotation.Nonempty;
import com.helger.html.css.ICSSClassProvider;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.grid.EBootstrapGridType;
import com.helger.photon.bootstrap4.grid.IBootstrapGridElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EBootstrapGridXS implements IBootstrapGridElement
{
    XS_1(1, CBootstrapCSS.COL_1, CBootstrapCSS.OFFSET_1),
    XS_2(2, CBootstrapCSS.COL_2, CBootstrapCSS.OFFSET_2),
    XS_3(3, CBootstrapCSS.COL_3, CBootstrapCSS.OFFSET_3),
    XS_4(4, CBootstrapCSS.COL_4, CBootstrapCSS.OFFSET_4),
    XS_5(5, CBootstrapCSS.COL_5, CBootstrapCSS.OFFSET_5),
    XS_6(6, CBootstrapCSS.COL_6, CBootstrapCSS.OFFSET_6),
    XS_7(7, CBootstrapCSS.COL_7, CBootstrapCSS.OFFSET_7),
    XS_8(8, CBootstrapCSS.COL_8, CBootstrapCSS.OFFSET_8),
    XS_9(9, CBootstrapCSS.COL_9, CBootstrapCSS.OFFSET_9),
    XS_10(10, CBootstrapCSS.COL_10, CBootstrapCSS.OFFSET_10),
    XS_11(11, CBootstrapCSS.COL_11, CBootstrapCSS.OFFSET_11),
    XS_12(12, CBootstrapCSS.COL_12, null),
    AUTO(-2, CBootstrapCSS.COL_AUTO, null),
    EVENLY(-3, CBootstrapCSS.COL, null);

    private final int m_nParts;
    private final ICSSClassProvider m_aCSSClass;
    private final ICSSClassProvider m_aCSSClassOffset;

    private EBootstrapGridXS(@Nullable int n2, ICSSClassProvider iCSSClassProvider, ICSSClassProvider iCSSClassProvider2) {
        this.m_nParts = n2;
        this.m_aCSSClass = iCSSClassProvider;
        this.m_aCSSClassOffset = iCSSClassProvider2;
    }

    @Override
    @Nonnull
    public EBootstrapGridType getGridType() {
        return EBootstrapGridType.XS;
    }

    @Override
    public int getParts() {
        return this.m_nParts;
    }

    @Nonnull
    @Nonempty
    public String getCSSClass() {
        return this.m_aCSSClass.getCSSClass();
    }

    @Nullable
    public ICSSClassProvider getCSSClassOffset() {
        return this.m_aCSSClassOffset;
    }

    @Override
    public boolean isMax() {
        return this == XS_12;
    }

    @Nullable
    public static EBootstrapGridXS getFromParts(int n) {
        switch (n) {
            case 1: {
                return XS_1;
            }
            case 2: {
                return XS_2;
            }
            case 3: {
                return XS_3;
            }
            case 4: {
                return XS_4;
            }
            case 5: {
                return XS_5;
            }
            case 6: {
                return XS_6;
            }
            case 7: {
                return XS_7;
            }
            case 8: {
                return XS_8;
            }
            case 9: {
                return XS_9;
            }
            case 10: {
                return XS_10;
            }
            case 11: {
                return XS_11;
            }
            case 12: {
                return XS_12;
            }
            case -2: {
                return AUTO;
            }
            case -3: {
                return EVENLY;
            }
        }
        return null;
    }
}

