/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.grid;

import com.helger.html.css.ICSSClassProvider;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.grid.EBootstrapGridType;
import com.helger.photon.bootstrap4.grid.IBootstrapGridElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EBootstrapGridLG implements IBootstrapGridElement
{
    LG_1(1, CBootstrapCSS.COL_LG_1, CBootstrapCSS.OFFSET_LG_1),
    LG_2(2, CBootstrapCSS.COL_LG_2, CBootstrapCSS.OFFSET_LG_2),
    LG_3(3, CBootstrapCSS.COL_LG_3, CBootstrapCSS.OFFSET_LG_3),
    LG_4(4, CBootstrapCSS.COL_LG_4, CBootstrapCSS.OFFSET_LG_4),
    LG_5(5, CBootstrapCSS.COL_LG_5, CBootstrapCSS.OFFSET_LG_5),
    LG_6(6, CBootstrapCSS.COL_LG_6, CBootstrapCSS.OFFSET_LG_6),
    LG_7(7, CBootstrapCSS.COL_LG_7, CBootstrapCSS.OFFSET_LG_7),
    LG_8(8, CBootstrapCSS.COL_LG_8, CBootstrapCSS.OFFSET_LG_8),
    LG_9(9, CBootstrapCSS.COL_LG_9, CBootstrapCSS.OFFSET_LG_9),
    LG_10(10, CBootstrapCSS.COL_LG_10, CBootstrapCSS.OFFSET_LG_10),
    LG_11(11, CBootstrapCSS.COL_LG_11, CBootstrapCSS.OFFSET_LG_11),
    LG_12(12, CBootstrapCSS.COL_LG_12, null),
    AUTO(-2, CBootstrapCSS.COL_LG_AUTO, null),
    EVENLY(-3, CBootstrapCSS.COL_LG, null);

    private final int m_nParts;
    private final ICSSClassProvider m_aCSSClass;
    private final ICSSClassProvider m_aCSSClassOffset;

    private EBootstrapGridLG(@Nullable int n2, ICSSClassProvider iCSSClassProvider, ICSSClassProvider iCSSClassProvider2) {
        this.m_nParts = n2;
        this.m_aCSSClass = iCSSClassProvider;
        this.m_aCSSClassOffset = iCSSClassProvider2;
    }

    @Override
    @Nonnull
    public EBootstrapGridType getGridType() {
        return EBootstrapGridType.LG;
    }

    @Override
    public int getParts() {
        return this.m_nParts;
    }

    @Nullable
    public String getCSSClass() {
        return this.m_aCSSClass == null ? null : this.m_aCSSClass.getCSSClass();
    }

    @Nullable
    public ICSSClassProvider getCSSClassOffset() {
        return this.m_aCSSClassOffset;
    }

    @Override
    public boolean isMax() {
        return this == LG_12;
    }

    @Nullable
    public static EBootstrapGridLG getFromParts(int n) {
        switch (n) {
            case 1: {
                return LG_1;
            }
            case 2: {
                return LG_2;
            }
            case 3: {
                return LG_3;
            }
            case 4: {
                return LG_4;
            }
            case 5: {
                return LG_5;
            }
            case 6: {
                return LG_6;
            }
            case 7: {
                return LG_7;
            }
            case 8: {
                return LG_8;
            }
            case 9: {
                return LG_9;
            }
            case 10: {
                return LG_10;
            }
            case 11: {
                return LG_11;
            }
            case 12: {
                return LG_12;
            }
            case -2: {
                return AUTO;
            }
            case -3: {
                return EVENLY;
            }
        }
        return null;
    }
}

