/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.grid;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.base.AbstractBootstrapDiv;
import com.helger.photon.bootstrap4.grid.BootstrapCol;
import com.helger.photon.bootstrap4.grid.BootstrapGridSpec;
import com.helger.photon.bootstrap4.grid.EBootstrapGridLG;
import com.helger.photon.bootstrap4.grid.EBootstrapGridMD;
import com.helger.photon.bootstrap4.grid.EBootstrapGridSM;
import com.helger.photon.bootstrap4.grid.EBootstrapGridXL;
import com.helger.photon.bootstrap4.grid.EBootstrapGridXS;
import com.helger.photon.bootstrap4.grid.EBootstrapRowVerticalAlign;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BootstrapRow
extends AbstractBootstrapDiv<BootstrapRow> {
    private EBootstrapRowVerticalAlign m_eVertAlign;
    private boolean m_bWithPadding = true;

    public BootstrapRow() {
        this.addClass(CBootstrapCSS.ROW);
    }

    @Nonnull
    public BootstrapRow setVerticalAlign(@Nullable EBootstrapRowVerticalAlign eBootstrapRowVerticalAlign) {
        this.m_eVertAlign = eBootstrapRowVerticalAlign;
        return this;
    }

    @Nullable
    public EBootstrapRowVerticalAlign getVertAlign() {
        return this.m_eVertAlign;
    }

    @Nonnull
    public BootstrapRow setWithPadding(boolean bl) {
        this.m_bWithPadding = bl;
        return this;
    }

    public boolean isWithPadding() {
        return this.m_bWithPadding;
    }

    @Nonnull
    public BootstrapCol createColumn(int n) {
        return this.createColumn(BootstrapGridSpec.create(n));
    }

    @Nonnull
    public BootstrapCol createColumn(int n, int n2, int n3, int n4, int n5) {
        return this.createColumn(BootstrapGridSpec.create(n, n2, n3, n4, n5));
    }

    @Nonnull
    public BootstrapCol createColumn(@Nullable EBootstrapGridXS eBootstrapGridXS, @Nullable EBootstrapGridSM eBootstrapGridSM, @Nullable EBootstrapGridMD eBootstrapGridMD, @Nullable EBootstrapGridLG eBootstrapGridLG, @Nullable EBootstrapGridXL eBootstrapGridXL) {
        return this.createColumn(new BootstrapGridSpec(eBootstrapGridXS, eBootstrapGridSM, eBootstrapGridMD, eBootstrapGridLG, eBootstrapGridXL));
    }

    @Nonnull
    public BootstrapCol createColumn(@Nonnull BootstrapGridSpec bootstrapGridSpec) {
        ValueEnforcer.notNull((Object)bootstrapGridSpec, (String)"GridSpec");
        BootstrapCol bootstrapCol = (BootstrapCol)this.addAndReturnChild((IHCNode)new BootstrapCol());
        bootstrapGridSpec.applyTo(bootstrapCol);
        return bootstrapCol;
    }

    @Nonnull
    public HCDiv createNewLine() {
        return (HCDiv)this.addAndReturnChild((IHCNode)((HCDiv)new HCDiv().addClass(CBootstrapCSS.W_100)));
    }

    @Nullable
    public BootstrapCol getFirstColumn() {
        return this.getColumnAtIndex(0);
    }

    @Nullable
    public BootstrapCol getColumnAtIndex(@Nonnegative int n) {
        int n2 = 0;
        for (IHCNode iHCNode : this.getChildren()) {
            if (!(iHCNode instanceof BootstrapCol)) continue;
            if (n2 == n) {
                return (BootstrapCol)iHCNode;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public BootstrapCol getLastColumn() {
        for (IHCNode iHCNode : this.getAllChildren().reverse()) {
            if (!(iHCNode instanceof BootstrapCol)) continue;
            return (BootstrapCol)iHCNode;
        }
        return null;
    }

    @Override
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClass(this.m_eVertAlign);
        if (!this.m_bWithPadding) {
            this.addClass(CBootstrapCSS.NO_GUTTERS);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static BootstrapRow createRowWithOneColumn(int n, @Nonnull IHCNode iHCNode) {
        BootstrapRow bootstrapRow = new BootstrapRow();
        bootstrapRow.createColumn(n).addChild(iHCNode);
        return bootstrapRow;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static BootstrapRow createRowWithOneColumn(int n, int n2, int n3, int n4, int n5, @Nonnull IHCNode iHCNode) {
        BootstrapRow bootstrapRow = new BootstrapRow();
        bootstrapRow.createColumn(n, n2, n3, n4, n5).addChild(iHCNode);
        return bootstrapRow;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static BootstrapRow createRowWithOneColumn(@Nonnull BootstrapGridSpec bootstrapGridSpec, @Nonnull IHCNode iHCNode) {
        BootstrapRow bootstrapRow = new BootstrapRow();
        bootstrapRow.createColumn(bootstrapGridSpec).addChild(iHCNode);
        return bootstrapRow;
    }
}

