/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.form;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.HCCtrlHelper;
import com.helger.html.hc.html.forms.IHCControl;
import com.helger.html.hc.html.forms.IHCInput;
import com.helger.html.hc.html.textlevel.HCSmall;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.form.BootstrapInvalidFeedback;
import com.helger.photon.uicore.html.formlabel.HCFormLabel;
import com.helger.photon.uicore.html.formlabel.HCFormLabelHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class BootstrapFormHelper {
    public static final ICSSClassProvider CSS_CLASS_FORM_GROUP_ERROR_TEXT = DefaultCSSClassProvider.create((String)"form-group-error-text");
    public static final ICSSClassProvider CSS_CLASS_FORM_GROUP_HELP_TEXT = DefaultCSSClassProvider.create((String)"form-group-help-text");
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapFormHelper.class);
    private static final BootstrapFormHelper INSTANCE = new BootstrapFormHelper();

    private BootstrapFormHelper() {
    }

    public static void markAsFormControl(@Nullable IHCNode iHCNode) {
        if (iHCNode instanceof IHCControl) {
            IHCInput iHCInput;
            EHCInputType eHCInputType;
            IHCControl iHCControl = (IHCControl)iHCNode;
            ICSSClassProvider iCSSClassProvider = CBootstrapCSS.FORM_CONTROL;
            if (iHCControl instanceof IHCInput && (eHCInputType = (iHCInput = (IHCInput)iHCControl).getType()) != null) {
                switch (eHCInputType) {
                    case CHECKBOX: 
                    case RADIO: {
                        iCSSClassProvider = CBootstrapCSS.FORM_CHECK_INPUT;
                        break;
                    }
                    case FILE: {
                        iCSSClassProvider = CBootstrapCSS.FORM_CONTROL_FILE;
                        break;
                    }
                    case HIDDEN: {
                        iCSSClassProvider = null;
                    }
                }
            }
            if (iCSSClassProvider != null) {
                iHCControl.addClass(iCSSClassProvider);
            }
        }
    }

    public static void markAsFormControls(@Nullable Iterable<? extends IHCNode> iterable) {
        if (iterable != null) {
            for (IHCNode iHCNode : iterable) {
                BootstrapFormHelper.markAsFormControl(iHCNode);
            }
        }
    }

    public static void markChildrenAsFormControls(@Nullable IHCNode iHCNode2) {
        if (iHCNode2 != null) {
            iHCNode2.forAllChildren(iHCNode -> BootstrapFormHelper.markAsFormControls((Iterable<? extends IHCNode>)HCCtrlHelper.getAllHCControls((IHCNode)iHCNode)));
        }
    }

    public static void connectFormControlWithLabel(@Nullable IHCElement<?> iHCElement, @Nullable HCFormLabel hCFormLabel) {
        if (iHCElement != null && hCFormLabel != null) {
            hCFormLabel.setFor(iHCElement);
            if (!iHCElement.customAttrs().containsAriaLabel() && !iHCElement.customAttrs().containsAriaLabeledBy()) {
                iHCElement.customAttrs().setAriaLabeledBy((IHCElement)hCFormLabel);
            }
        }
    }

    public static void connectFormControlsWithLabel(@Nullable Iterable<? extends IHCElement<?>> iterable, @Nullable HCFormLabel hCFormLabel) {
        if (iterable != null && hCFormLabel != null) {
            boolean bl = hCFormLabel.getType().isMandatory();
            boolean bl2 = false;
            for (IHCElement<?> iHCElement : iterable) {
                if (bl) {
                    iHCElement.customAttrs().setAriaRequired(true);
                }
                boolean bl3 = false;
                if (!bl2) {
                    hCFormLabel.setFor(iHCElement);
                    bl2 = true;
                    bl3 = true;
                }
                if (bl3 || iHCElement.customAttrs().containsAriaLabel() || iHCElement.customAttrs().containsAriaLabeledBy()) continue;
                iHCElement.customAttrs().setAriaLabeledBy((IHCElement)hCFormLabel);
            }
        }
    }

    public static void connectFormControlsWithErrors(@Nullable Iterable<? extends IHCElement<?>> iterable, @Nullable ICommonsCollection<? extends IHCElement<?>> iCommonsCollection) {
        String string;
        if (iterable != null && iCommonsCollection != null && StringHelper.isNotEmpty((String)(string = StringImplode.imploder().source(iCommonsCollection, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build()))) {
            for (IHCElement<?> iHCElement2 : iterable) {
                if (iHCElement2.customAttrs().containsAriaDescription() || iHCElement2.customAttrs().containsAriaDescribedBy()) continue;
                iHCElement2.customAttrs().setAriaDescribedBy(string);
            }
        }
    }

    public static void connectFormControlsWithHelpText(@Nullable Iterable<? extends IHCElement<?>> iterable, @Nullable IHCElement<?> iHCElement) {
        if (iterable != null && iHCElement != null) {
            String string = ((IHCElement)iHCElement.ensureID()).getID();
            for (IHCElement<?> iHCElement2 : iterable) {
                if (iHCElement2.customAttrs().containsAriaDescription() || iHCElement2.customAttrs().containsAriaDescribedBy()) continue;
                iHCElement2.customAttrs().setAriaDescribedBy(string);
            }
        }
    }

    public static void applyFormControlValidityState(@Nullable IHCElement<?> iHCElement, @Nullable IErrorList iErrorList) {
        ValueEnforcer.notNull(iHCElement, (String)"Element");
        if (iErrorList != null && iErrorList.containsAtLeastOneError()) {
            iHCElement.addClass(CBootstrapCSS.IS_INVALID);
            iHCElement.customAttrs().setAriaInvalid(true);
        }
    }

    public static void applyFormControlValidityState(@Nullable Iterable<? extends IHCElement<?>> iterable, @Nullable IErrorList iErrorList) {
        if (iterable != null && iErrorList != null && iErrorList.containsAtLeastOneError()) {
            for (IHCElement<?> iHCElement : iterable) {
                iHCElement.addClass(CBootstrapCSS.IS_INVALID);
                iHCElement.customAttrs().setAriaInvalid(true);
            }
        }
    }

    @Nonnull
    public static BootstrapInvalidFeedback createDefaultErrorNode(@Nonnull IError iError, @Nonnull Locale locale) {
        return BootstrapFormHelper.createDefaultErrorNode(iError, locale, false);
    }

    @Nonnull
    public static BootstrapInvalidFeedback createDefaultErrorNode(@Nonnull IError iError, @Nonnull Locale locale, boolean bl) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl && StringHelper.isNotEmpty((String)(object = iError.getErrorLocation().getAsString()))) {
            stringBuilder.append((String)object).append(" ");
        }
        if (StringHelper.isNotEmpty((String)(object = iError.getErrorID()))) {
            stringBuilder.append("[").append((String)object).append("] ");
        }
        if (StringHelper.isEmpty((String)(object = StringHelper.getNotNull((String)iError.getErrorText(locale))))) {
            LOGGER.warn("Error " + String.valueOf(iError) + " has no text in locale " + String.valueOf(locale));
        } else {
            stringBuilder.append((String)object);
        }
        object = (BootstrapInvalidFeedback)new BootstrapInvalidFeedback().addClass(CSS_CLASS_FORM_GROUP_ERROR_TEXT);
        object.addChild(stringBuilder.toString());
        return object;
    }

    @Nonnull
    public static HCNodeList createDefaultErrorNode(@Nullable IErrorList iErrorList, @Nonnull Locale locale) {
        return BootstrapFormHelper.createDefaultErrorNode(iErrorList, locale, false);
    }

    @Nonnull
    public static HCNodeList createDefaultErrorNode(@Nullable IErrorList iErrorList, @Nonnull Locale locale, boolean bl) {
        HCNodeList hCNodeList = new HCNodeList();
        if (iErrorList != null) {
            for (IError iError : iErrorList) {
                hCNodeList.addChild((IHCNode)BootstrapFormHelper.createDefaultErrorNode(iError, locale, bl));
            }
        }
        return hCNodeList;
    }

    @Nullable
    public static IHCElementWithChildren<?> createDefaultHelpTextNode(@Nullable String string) {
        return BootstrapFormHelper.createDefaultHelpTextNode((IHCNode)HCTextNode.createOnDemand((String)string));
    }

    @Nullable
    public static IHCElementWithChildren<?> createDefaultHelpTextNode(@Nullable IHCNode iHCNode) {
        if (iHCNode == null) {
            return null;
        }
        HCSmall hCSmall = new HCSmall();
        hCSmall.addClass(CBootstrapCSS.FORM_TEXT);
        hCSmall.addClass(CBootstrapCSS.TEXT_MUTED);
        hCSmall.addClass(CSS_CLASS_FORM_GROUP_HELP_TEXT);
        hCSmall.addChild(iHCNode);
        return hCSmall;
    }

    @Nonnull
    public static String getDefaultPlaceholderText(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren) {
        if (iHCElementWithChildren instanceof HCFormLabel) {
            return iHCElementWithChildren.getPlainText();
        }
        return HCFormLabelHelper.trimAllKnownSuffixes((String)iHCElementWithChildren.getPlainText());
    }

    @Nonnull
    public static HCNodeList createStandaloneFormCtrl(@Nullable IHCNode iHCNode, @Nullable IErrorList iErrorList, @Nonnull Locale locale) {
        BootstrapFormHelper.markAsFormControl(iHCNode);
        if (iHCNode instanceof IHCElement) {
            BootstrapFormHelper.applyFormControlValidityState((IHCElement)iHCNode, iErrorList);
        }
        return (HCNodeList)((HCNodeList)new HCNodeList().addChild(iHCNode)).addChild((IHCNode)BootstrapFormHelper.createDefaultErrorNode(iErrorList, locale));
    }
}

