/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.ext;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.photon.bootstrap4.alert.AbstractBootstrapAlert;
import com.helger.photon.bootstrap4.alert.EBootstrapAlertType;
import com.helger.photon.core.mgr.PhotonBasicManager;
import com.helger.photon.core.systemmsg.ESystemMessageType;
import com.helger.photon.core.systemmsg.ISystemMessageRenderer;
import com.helger.photon.core.systemmsg.SystemMessageManager;
import com.helger.photon.uicore.systemmsg.SystemMessageRendererMarkdown;
import com.helger.photon.uicore.systemmsg.SystemMessageRendererPlainText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BootstrapSystemMessage
extends AbstractBootstrapAlert<BootstrapSystemMessage> {
    public static final ISystemMessageRenderer FORMATTER_DEFAULT = SystemMessageRendererPlainText.INSTANCE;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static ISystemMessageRenderer s_aFormatter = FORMATTER_DEFAULT;

    @Nonnull
    public static ISystemMessageRenderer getDefaultFormatter() {
        return (ISystemMessageRenderer)RW_LOCK.readLockedGet(() -> s_aFormatter);
    }

    public static void setDefaultFormatter(@Nonnull ISystemMessageRenderer iSystemMessageRenderer) {
        ValueEnforcer.notNull((Object)iSystemMessageRenderer, (String)"Formatter");
        RW_LOCK.writeLocked(() -> {
            s_aFormatter = iSystemMessageRenderer;
        });
    }

    public static boolean isDefaultMarkdown() {
        return BootstrapSystemMessage.getDefaultFormatter() instanceof SystemMessageRendererMarkdown;
    }

    public static void setDefaultUseMarkdown(boolean bl) {
        BootstrapSystemMessage.setDefaultFormatter((ISystemMessageRenderer)(bl ? SystemMessageRendererMarkdown.INSTANCE : SystemMessageRendererPlainText.INSTANCE));
    }

    @Nonnull
    public static EBootstrapAlertType getAlertType(@Nonnull ESystemMessageType eSystemMessageType) {
        switch (eSystemMessageType) {
            case INFO: {
                return EBootstrapAlertType.INFO;
            }
            case WARNING: {
                return EBootstrapAlertType.WARNING;
            }
            case ERROR: {
                return EBootstrapAlertType.DANGER;
            }
            case SUCCESS: {
                return EBootstrapAlertType.SUCCESS;
            }
        }
        throw new IllegalArgumentException("Illegal message type: " + String.valueOf(eSystemMessageType));
    }

    protected BootstrapSystemMessage(@Nonnull ESystemMessageType eSystemMessageType) {
        super(BootstrapSystemMessage.getAlertType(eSystemMessageType));
    }

    @Nonnull
    public BootstrapSystemMessage setSystemMessage(@Nullable String string) {
        this.removeAllChildren();
        if (StringHelper.isNotEmpty((String)string)) {
            BootstrapSystemMessage.getDefaultFormatter().renderSystemMessage(string, (IHCElementWithChildren)this);
        }
        return this;
    }

    @Nullable
    public static BootstrapSystemMessage createDefault() {
        SystemMessageManager systemMessageManager = PhotonBasicManager.getSystemMessageMgr();
        return BootstrapSystemMessage.create(systemMessageManager.getMessageType(), systemMessageManager.getSystemMessage());
    }

    @Nullable
    public static BootstrapSystemMessage create(@Nonnull ESystemMessageType eSystemMessageType, @Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return new BootstrapSystemMessage(eSystemMessageType).setSystemMessage(string);
    }
}

