/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.button;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.EHTMLRole;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.textlevel.AbstractHCA;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.button.BootstrapButton;
import com.helger.photon.bootstrap4.button.EBootstrapButtonSize;
import com.helger.photon.bootstrap4.button.EBootstrapButtonType;
import com.helger.photon.uicore.icon.IIcon;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BootstrapLinkButton
extends AbstractHCA<BootstrapLinkButton> {
    private EBootstrapButtonType m_eButtonType = EBootstrapButtonType.DEFAULT;
    private EBootstrapButtonSize m_eButtonSize = EBootstrapButtonSize.DEFAULT;
    private IIcon m_aIcon;

    public BootstrapLinkButton() {
        this(EBootstrapButtonType.DEFAULT, EBootstrapButtonSize.DEFAULT);
    }

    public BootstrapLinkButton(@Nonnull EBootstrapButtonType eBootstrapButtonType) {
        this(eBootstrapButtonType, EBootstrapButtonSize.DEFAULT);
    }

    public BootstrapLinkButton(@Nonnull EBootstrapButtonSize eBootstrapButtonSize) {
        this(EBootstrapButtonType.DEFAULT, eBootstrapButtonSize);
    }

    public BootstrapLinkButton(@Nonnull EBootstrapButtonType eBootstrapButtonType, @Nonnull EBootstrapButtonSize eBootstrapButtonSize) {
        this.setRole(EHTMLRole.BUTTON);
        this.addClass(CBootstrapCSS.BTN);
        this.setButtonType(eBootstrapButtonType);
        this.setButtonSize(eBootstrapButtonSize);
    }

    @Nonnull
    public EBootstrapButtonType getButtonType() {
        return this.m_eButtonType;
    }

    @Nonnull
    public final BootstrapLinkButton setButtonType(@Nonnull EBootstrapButtonType eBootstrapButtonType) {
        this.m_eButtonType = (EBootstrapButtonType)((Object)ValueEnforcer.notNull((Object)((Object)eBootstrapButtonType), (String)"ButtonType"));
        return this;
    }

    @Nullable
    public EBootstrapButtonSize getButtonSize() {
        return this.m_eButtonSize;
    }

    @Nonnull
    public final BootstrapLinkButton setButtonSize(@Nonnull EBootstrapButtonSize eBootstrapButtonSize) {
        this.m_eButtonSize = (EBootstrapButtonSize)((Object)ValueEnforcer.notNull((Object)((Object)eBootstrapButtonSize), (String)"ButtonSize"));
        return this;
    }

    @Nullable
    public IIcon getIcon() {
        return this.m_aIcon;
    }

    @Nonnull
    public final BootstrapLinkButton setIcon(@Nullable IIcon iIcon) {
        this.m_aIcon = iIcon;
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClasses(new ICSSClassProvider[]{this.getButtonType(), this.getButtonSize()});
        if (this.m_aIcon != null) {
            this.addClass(BootstrapButton.CSS_CLASS_BTN_WITH_ICON);
            boolean bl = this.hasChildren();
            this.addChildAt(0, (IHCNode)this.m_aIcon.getAsNode());
            if (bl) {
                this.addChildAt(1, (IHCNode)new HCTextNode(" "));
            }
        }
    }
}

