/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.button;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.AbstractHCButton;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.button.EBootstrapButtonSize;
import com.helger.photon.bootstrap4.button.EBootstrapButtonType;
import com.helger.photon.uicore.icon.IIcon;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BootstrapButton
extends AbstractHCButton<BootstrapButton> {
    public static final ICSSClassProvider CSS_CLASS_BTN_WITH_ICON = DefaultCSSClassProvider.create((String)"btn-with-icon");
    private EBootstrapButtonType m_eButtonType = EBootstrapButtonType.DEFAULT;
    private EBootstrapButtonSize m_eButtonSize = EBootstrapButtonSize.DEFAULT;
    private IIcon m_aIcon;
    private boolean m_bBlockLevel = false;

    public BootstrapButton() {
        this(EBootstrapButtonType.DEFAULT, EBootstrapButtonSize.DEFAULT);
    }

    public BootstrapButton(@Nonnull EBootstrapButtonType eBootstrapButtonType) {
        this(eBootstrapButtonType, EBootstrapButtonSize.DEFAULT);
    }

    public BootstrapButton(@Nonnull EBootstrapButtonSize eBootstrapButtonSize) {
        this(EBootstrapButtonType.DEFAULT, eBootstrapButtonSize);
    }

    public BootstrapButton(@Nonnull EBootstrapButtonType eBootstrapButtonType, @Nonnull EBootstrapButtonSize eBootstrapButtonSize) {
        this.addClass(CBootstrapCSS.BTN);
        this.setButtonType(eBootstrapButtonType);
        this.setButtonSize(eBootstrapButtonSize);
    }

    @Nonnull
    public final EBootstrapButtonType getButtonType() {
        return this.m_eButtonType;
    }

    @Nonnull
    public final BootstrapButton setButtonType(@Nonnull EBootstrapButtonType eBootstrapButtonType) {
        this.m_eButtonType = (EBootstrapButtonType)((Object)ValueEnforcer.notNull((Object)((Object)eBootstrapButtonType), (String)"ButtonType"));
        return this;
    }

    @Nullable
    public final EBootstrapButtonSize getButtonSize() {
        return this.m_eButtonSize;
    }

    @Nonnull
    public final BootstrapButton setButtonSize(@Nonnull EBootstrapButtonSize eBootstrapButtonSize) {
        this.m_eButtonSize = (EBootstrapButtonSize)((Object)ValueEnforcer.notNull((Object)((Object)eBootstrapButtonSize), (String)"ButtonSize"));
        return this;
    }

    public final boolean isBlockLevel() {
        return this.m_bBlockLevel;
    }

    @Nonnull
    public final BootstrapButton setBlockLevel(boolean bl) {
        this.m_bBlockLevel = bl;
        return this;
    }

    @Nullable
    public final IIcon getIcon() {
        return this.m_aIcon;
    }

    @Nonnull
    public final BootstrapButton setIcon(@Nullable IIcon iIcon) {
        this.m_aIcon = iIcon;
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClasses(new ICSSClassProvider[]{this.getButtonType(), this.getButtonSize()});
        if (this.m_bBlockLevel) {
            this.addClass(CBootstrapCSS.BTN_BLOCK);
        }
        if (this.m_aIcon != null) {
            this.addClass(CSS_CLASS_BTN_WITH_ICON);
            boolean bl = this.hasChildren();
            this.addChildAt(0, (IHCNode)this.m_aIcon.getAsNode());
            if (bl) {
                this.addChildAt(1, (IHCNode)new HCTextNode(" "));
            }
        }
    }
}

