/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.breadcrumb;

import com.helger.annotation.concurrent.Immutable;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.photon.bootstrap4.breadcrumb.BootstrapBreadcrumb;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.menu.IMenuItem;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import java.util.Locale;

@Immutable
public final class BootstrapBreadcrumbProvider {
    private BootstrapBreadcrumbProvider() {
    }

    @Nonnull
    public static BootstrapBreadcrumb createBreadcrumb(@Nonnull ILayoutExecutionContext iLayoutExecutionContext) {
        Locale locale = iLayoutExecutionContext.getDisplayLocale();
        IMenuTree iMenuTree = iLayoutExecutionContext.getMenuTree();
        BootstrapBreadcrumb bootstrapBreadcrumb = new BootstrapBreadcrumb();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IMenuItemPage iMenuItemPage = iLayoutExecutionContext.getSelectedMenuItem();
        while (iMenuItemPage != null) {
            commonsArrayList.add(0, (Object)iMenuItemPage);
            DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)iMenuTree.getItemWithID((Object)((String)iMenuItemPage.getID()));
            iMenuItemPage = defaultTreeItemWithID.isRootItem() ? null : (IMenuItem)((DefaultTreeItemWithID)defaultTreeItemWithID.getParent()).getData();
        }
        int n = commonsArrayList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                IMenuItem iMenuItem = (IMenuItem)commonsArrayList.get(i);
                if (i < n - 1) {
                    bootstrapBreadcrumb.getList().addLink((ISimpleURL)iLayoutExecutionContext.getLinkToMenuItem((String)iMenuItem.getID()), iMenuItem.getDisplayText(locale));
                    continue;
                }
                bootstrapBreadcrumb.getList().addActive(iMenuItem.getDisplayText(locale));
            }
        }
        return bootstrapBreadcrumb;
    }
}

