/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.base;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.string.StringHelper;
import com.helger.css.property.CCSSProperties;
import com.helger.css.property.ECSSProperty;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.ext.HCHasCSSClasses;
import com.helger.html.hc.ext.HCHasCSSStyles;
import com.helger.html.hc.html.IHCElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public abstract class AbstractBootstrapObject<IMPLTYPE extends AbstractBootstrapObject<IMPLTYPE>>
implements IHCHasID<IMPLTYPE> {
    private String m_sID;
    private HCHasCSSClasses m_aCSSClasses;
    private HCHasCSSStyles m_aCSSStyles;

    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    @Nonnull
    public final IMPLTYPE setID(@Nullable String string) {
        return this.setID(string, false);
    }

    @Nonnull
    public final IMPLTYPE setID(@Nullable String string, boolean bl) {
        if (!bl && this.m_sID != null) {
            if (StringHelper.isNotEmpty((String)string)) {
                if (!this.m_sID.equals(string)) {
                    HCConsistencyChecker.consistencyError((String)("Overwriting HC object ID '" + this.m_sID + "' with '" + string + "' - this may have side effects!"));
                }
            } else {
                HCConsistencyChecker.consistencyError((String)("The HC object ID '" + this.m_sID + "' will be removed - this may have side effects"));
            }
        }
        this.m_sID = string;
        return (IMPLTYPE)((AbstractBootstrapObject)this.thisAsT());
    }

    public final boolean hasCSSClasses() {
        return this.m_aCSSClasses != null;
    }

    @Nonnull
    @ReturnsMutableObject
    public final HCHasCSSClasses cssClasses() {
        if (this.m_aCSSClasses == null) {
            this.m_aCSSClasses = new HCHasCSSClasses();
        }
        return this.m_aCSSClasses;
    }

    public final boolean hasCSSStyles() {
        return this.m_aCSSStyles != null;
    }

    @Nonnull
    @ReturnsMutableObject
    public final HCHasCSSStyles cssStyles() {
        if (this.m_aCSSStyles == null) {
            this.m_aCSSStyles = new HCHasCSSStyles();
        }
        return this.m_aCSSStyles;
    }

    @Nonnull
    public final IMPLTYPE setHidden(boolean bl) {
        if (bl) {
            this.cssStyles().addStyle(CCSSProperties.DISPLAY_NONE);
        } else if (this.m_aCSSStyles != null) {
            this.m_aCSSStyles.removeStyle(ECSSProperty.DISPLAY);
        }
        return (IMPLTYPE)((AbstractBootstrapObject)this.thisAsT());
    }

    public final void applyBasicHTMLTo(@Nonnull IHCElement<?> iHCElement) {
        if (this.hasID()) {
            iHCElement.setID(this.getID());
        }
        if (this.m_aCSSClasses != null) {
            iHCElement.addClasses((Iterable)this.m_aCSSClasses.getAllClasses());
        }
        if (this.m_aCSSStyles != null) {
            iHCElement.addStyles((Iterable)this.m_aCSSStyles.getAllStyleValues());
        }
    }
}

