/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.bootstrap4.EBootstrapCSSPathProvider;
import com.helger.photon.bootstrap4.EBootstrapJSPathProvider;
import com.helger.photon.uicore.EUICoreJSPathProvider;
import jakarta.annotation.Nonnull;

@ThreadSafe
public final class BootstrapCustomConfig {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final ICommonsList<ICSSPathProvider> CSS = new CommonsArrayList();
    private static final ICommonsList<IJSPathProvider> JS = new CommonsArrayList();

    private BootstrapCustomConfig() {
    }

    public static void setBootstrapCSS(ICSSPathProvider ... iCSSPathProviderArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iCSSPathProviderArray, (String)"CSSPathProvider");
        RW_LOCK.writeLocked(() -> CSS.setAll((Object[])iCSSPathProviderArray));
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<ICSSPathProvider> getAllBootstrapCSS() {
        return (ICommonsList)RW_LOCK.readLockedGet(() -> CSS.getClone());
    }

    public static void setBootstrapJS(IJSPathProvider ... iJSPathProviderArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iJSPathProviderArray, (String)"JSPathProvider");
        RW_LOCK.writeLocked(() -> JS.setAll((Object[])iJSPathProviderArray));
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IJSPathProvider> getAllBootstrapJS() {
        return (ICommonsList)RW_LOCK.readLockedGet(() -> JS.getClone());
    }

    static {
        CSS.add((Object)EBootstrapCSSPathProvider.BOOTSTRAP);
        CSS.add((Object)EBootstrapCSSPathProvider.BOOTSTRAP_PH);
        JS.add((Object)EUICoreJSPathProvider.POPPER);
        JS.add((Object)EBootstrapJSPathProvider.BOOTSTRAP);
        JS.add((Object)EBootstrapJSPathProvider.BOOTSTRAP_PH);
    }
}

