/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.treeview;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import jakarta.annotation.Nonnull;

@NotThreadSafe
public class BootstrapTreeViewItem {
    private final IJSExpression m_aText;
    private boolean m_bSelectable = false;
    private boolean m_bDisabled = false;
    private boolean m_bChecked = false;

    public BootstrapTreeViewItem(@Nonnull IHCNode iHCNode) {
        this(HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode));
    }

    public BootstrapTreeViewItem(@Nonnull String string) {
        this((IJSExpression)JSExpr.lit((String)string));
    }

    public BootstrapTreeViewItem(@Nonnull IJSExpression iJSExpression) {
        this.m_aText = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Text");
    }

    @Nonnull
    public IJSExpression getText() {
        return this.m_aText;
    }

    public void setSelectable(boolean bl) {
        this.m_bSelectable = bl;
    }

    public boolean isSelectable() {
        return this.m_bSelectable;
    }

    public void setDisabled(boolean bl) {
        this.m_bDisabled = bl;
    }

    public boolean isDisabled() {
        return this.m_bDisabled;
    }

    public void setChecked(boolean bl) {
        this.m_bChecked = bl;
    }

    public boolean isChecked() {
        return this.m_bChecked;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getAsJSAssocArray() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add("text", this.m_aText);
        if (this.m_bSelectable) {
            jSAssocArray.add("selectable", true);
        }
        if (this.m_bDisabled) {
            jSAssocArray.add("disabled", true);
        }
        if (this.m_bChecked) {
            jSAssocArray.add("checked", true);
        }
        return jSAssocArray;
    }
}

