/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.treeview;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.collection.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCHasCSSClasses;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.script.HCScriptInline;
import com.helger.html.jquery.JQuery;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.bootstrap4.uictrls.EBootstrapUICtrlsCSSPathProvider;
import com.helger.photon.bootstrap4.uictrls.EBootstrapUICtrlsJSPathProvider;
import com.helger.photon.bootstrap4.uictrls.treeview.BootstrapTreeViewItem;
import com.helger.tree.BasicTree;
import com.helger.tree.DefaultTree;
import com.helger.tree.DefaultTreeItem;
import com.helger.tree.ITreeItem;
import com.helger.tree.util.TreeVisitor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;

public class BootstrapTreeView
extends AbstractHCDiv<BootstrapTreeView> {
    private final DefaultTree<BootstrapTreeViewItem> m_aTree;
    private HCHasCSSClasses m_aCollapseIcon;
    private HCHasCSSClasses m_aEmptyIcon;
    private HCHasCSSClasses m_aExpandIcon;
    private HCHasCSSClasses m_aNodeIcon;
    private ETriState m_eEnableLinks = ETriState.UNDEFINED;
    private ETriState m_eHighlightSelected = ETriState.UNDEFINED;
    private Integer m_aInitialLevels;
    private ETriState m_eShowBorder = ETriState.UNDEFINED;
    private ETriState m_eShowTags = ETriState.UNDEFINED;

    public BootstrapTreeView(@Nonnull DefaultTree<BootstrapTreeViewItem> defaultTree) {
        this.m_aTree = (DefaultTree)ValueEnforcer.notNull(defaultTree, (String)"Tree");
        this.ensureID();
    }

    @Nonnull
    public BootstrapTreeView setCollapseIcon(@Nullable HCHasCSSClasses hCHasCSSClasses) {
        this.m_aCollapseIcon = hCHasCSSClasses;
        return this;
    }

    @Nonnull
    public BootstrapTreeView setEmptyIcon(@Nullable HCHasCSSClasses hCHasCSSClasses) {
        this.m_aEmptyIcon = hCHasCSSClasses;
        return this;
    }

    @Nonnull
    public BootstrapTreeView setExpandIcon(@Nullable HCHasCSSClasses hCHasCSSClasses) {
        this.m_aExpandIcon = hCHasCSSClasses;
        return this;
    }

    @Nonnull
    public BootstrapTreeView setNodeIcon(@Nullable HCHasCSSClasses hCHasCSSClasses) {
        this.m_aNodeIcon = hCHasCSSClasses;
        return this;
    }

    @Nonnull
    public BootstrapTreeView setEnableLinks(boolean bl) {
        this.m_eEnableLinks = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public BootstrapTreeView setHighlightSelected(boolean bl) {
        this.m_eHighlightSelected = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public BootstrapTreeView setInitialLevels(int n) {
        this.m_aInitialLevels = n;
        return this;
    }

    @Nonnull
    public BootstrapTreeView setShowBorder(boolean bl) {
        this.m_eShowBorder = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public BootstrapTreeView setShowTags(boolean bl) {
        this.m_eShowTags = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    public JSInvocation invoke() {
        return JQuery.idRef((IHCHasID)this).invoke("treeview");
    }

    @Nonnull
    public JSInvocation getJSRemoveInvocation() {
        return (JSInvocation)this.invoke().arg("remove");
    }

    @Nonnull
    public JSInvocation getJSExpandAllInvocation() {
        return (JSInvocation)this.invoke().arg("expandAll");
    }

    @Nonnull
    public JSInvocation getJSExpandAllInvocation(int n) {
        return (JSInvocation)this.getJSExpandAllInvocation().arg((IJSExpression)new JSAssocArray().add("levels", n));
    }

    @Nonnull
    public JSInvocation getJSExpandAllInvocation(int n, boolean bl) {
        return (JSInvocation)this.getJSExpandAllInvocation().arg((IJSExpression)new JSAssocArray().add("levels", n).add("silent", bl));
    }

    @Nonnull
    public JSInvocation getJSCollapseAllInvocation() {
        return (JSInvocation)this.invoke().arg("collapseAll");
    }

    @Nonnull
    public JSInvocation getJSCollapseAllInvocation(int n) {
        return (JSInvocation)this.getJSCollapseAllInvocation().arg((IJSExpression)new JSAssocArray().add("levels", n));
    }

    @Nonnull
    public JSInvocation getJSCollapseAllInvocation(int n, boolean bl) {
        return (JSInvocation)this.getJSCollapseAllInvocation().arg((IJSExpression)new JSAssocArray().add("levels", n).add("silent", bl));
    }

    private static void _recursiveFillJSTree(@Nullable ICommonsList<DefaultTreeItem<BootstrapTreeViewItem>> iCommonsList, @Nonnull JSArray jSArray) {
        if (CollectionHelper.isNotEmpty(iCommonsList)) {
            for (DefaultTreeItem defaultTreeItem : iCommonsList) {
                JSAssocArray jSAssocArray = ((BootstrapTreeViewItem)defaultTreeItem.getData()).getAsJSAssocArray();
                JSArray jSArray2 = new JSArray();
                BootstrapTreeView._recursiveFillJSTree((ICommonsList<DefaultTreeItem<BootstrapTreeViewItem>>)defaultTreeItem.getAllChildren(), jSArray2);
                if (jSArray2.isNotEmpty()) {
                    jSAssocArray.add("nodes", (IJSExpression)jSArray2);
                }
                jSArray.add((IJSExpression)jSAssocArray);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSArray getJSDataArray() {
        JSArray jSArray = new JSArray();
        BootstrapTreeView._recursiveFillJSTree((ICommonsList<DefaultTreeItem<BootstrapTreeViewItem>>)((DefaultTreeItem)this.m_aTree.getRootItem()).getAllChildren(), jSArray);
        return jSArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public JSAssocArray getJSOptions() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add("data", (IJSExpression)this.getJSDataArray());
        if (this.m_aCollapseIcon != null) {
            jSAssocArray.add("collapseIcon", this.m_aCollapseIcon.getAllClassesAsString());
        }
        if (this.m_aEmptyIcon != null) {
            jSAssocArray.add("emptyIcon", this.m_aEmptyIcon.getAllClassesAsString());
        }
        if (this.m_aExpandIcon != null) {
            jSAssocArray.add("expandIcon", this.m_aExpandIcon.getAllClassesAsString());
        }
        if (this.m_aNodeIcon != null) {
            jSAssocArray.add("nodeIcon", this.m_aNodeIcon.getAllClassesAsString());
        }
        if (this.m_eEnableLinks.isDefined()) {
            jSAssocArray.add("enableLinks", this.m_eEnableLinks.getAsBooleanValue(false));
        }
        if (this.m_eHighlightSelected.isDefined()) {
            jSAssocArray.add("highlightSelected", this.m_eHighlightSelected.getAsBooleanValue(true));
        }
        if (this.m_aInitialLevels != null) {
            jSAssocArray.add("levels", this.m_aInitialLevels.intValue());
        }
        if (this.m_eShowBorder.isDefined()) {
            jSAssocArray.add("showBorder", this.m_eShowBorder.getAsBooleanValue(true));
        }
        if (this.m_eShowTags.isDefined()) {
            jSAssocArray.add("showTags", this.m_eShowTags.getAsBooleanValue(false));
        }
        return jSAssocArray;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        JSAssocArray jSAssocArray = this.getJSOptions();
        iHCHasChildrenMutable.addChild((IHCNode)new HCScriptInline((IHasJSCode)this.invoke().arg((IJSExpression)jSAssocArray)));
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EBootstrapUICtrlsJSPathProvider.TREE_VIEW);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EBootstrapUICtrlsCSSPathProvider.TREE_VIEW);
    }

    @Nonnull
    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> BootstrapTreeView create(@Nonnull BasicTree<DATATYPE, ITEMTYPE> basicTree, final @Nonnull Function<DATATYPE, BootstrapTreeViewItem> function) {
        DefaultTree defaultTree = new DefaultTree();
        final NonBlockingStack nonBlockingStack = new NonBlockingStack();
        nonBlockingStack.push((Object)((DefaultTreeItem)defaultTree.getRootItem()));
        TreeVisitor.visitTree(basicTree, (IHierarchyVisitorCallback)new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            public EHierarchyVisitorReturn onItemBeforeChildren(@Nonnull ITEMTYPE ITEMTYPE) {
                DefaultTreeItem defaultTreeItem = (DefaultTreeItem)((DefaultTreeItem)nonBlockingStack.peek()).createChildItem((Object)((BootstrapTreeViewItem)function.apply(ITEMTYPE.getData())));
                nonBlockingStack.push((Object)defaultTreeItem);
                return EHierarchyVisitorReturn.CONTINUE;
            }

            public EHierarchyVisitorReturn onItemAfterChildren(@Nonnull ITEMTYPE ITEMTYPE) {
                nonBlockingStack.pop();
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
        return new BootstrapTreeView((DefaultTree<BootstrapTreeViewItem>)defaultTree);
    }
}

