/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.ext;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.misc.Translatable;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayTextWithArgs;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@Immutable
public final class BootstrapTechnicalUI {
    private BootstrapTechnicalUI() {
    }

    @Nonnull
    private static String _getString(@Nonnull Throwable throwable) {
        return StringHelper.getConcatenatedOnDemand((String)ClassHelper.getClassLocalName(throwable.getClass()), (String)" - ", (String)throwable.getMessage());
    }

    @Nullable
    public static HCNodeList getTechnicalDetailsNode(@Nullable Throwable throwable, @Nonnull Locale locale) {
        if (throwable == null) {
            return null;
        }
        HCNodeList hCNodeList = new HCNodeList();
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (hCNodeList.hasNoChildren()) {
                hCNodeList.addChild((IHCNode)new HCDiv().addChild(EText.TECHNICAL_DETAILS.getDisplayText(locale) + ": " + BootstrapTechnicalUI._getString(throwable2)));
                continue;
            }
            hCNodeList.addChild((IHCNode)new HCDiv().addChild(EText.CAUSED_BY.getDisplayText(locale) + ": " + BootstrapTechnicalUI._getString(throwable2)));
        }
        return hCNodeList;
    }

    @Nullable
    public static String getTechnicalDetailsString(@Nullable Throwable throwable, @Nonnull Locale locale) {
        if (throwable == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(EText.TECHNICAL_DETAILS.getDisplayText(locale));
            } else {
                stringBuilder.append('\n').append(EText.CAUSED_BY.getDisplayText(locale));
            }
            stringBuilder.append(": ").append(BootstrapTechnicalUI._getString(throwable2));
        }
        return stringBuilder.toString();
    }

    @Translatable
    public static enum EText implements IHasDisplayTextWithArgs
    {
        TECHNICAL_DETAILS("Technische Details", "Technical details"),
        CAUSED_BY("Verursacht von", "Caused by");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

