/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.ext;

import com.helger.base.reflection.GenericReflection;
import com.helger.base.string.StringHelper;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.IHCNodeWithChildren;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.textlevel.HCSpan;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap4.breadcrumb.BootstrapBreadcrumb;
import com.helger.photon.bootstrap4.breadcrumb.BootstrapBreadcrumbProvider;
import com.helger.photon.bootstrap4.ext.BootstrapSystemMessage;
import com.helger.photon.bootstrap4.uictrls.ext.BootstrapMenuItemRenderer;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.interror.InternalErrorBuilder;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.menu.MenuItemDeterminatorCallback;
import com.helger.photon.uicore.page.IWebPage;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.WebPageExecutionContext;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.forcedredirect.ForcedRedirectException;
import com.helger.xservlet.forcedredirect.ForcedRedirectManager;
import jakarta.annotation.Nonnull;
import java.util.function.BiFunction;

public final class BootstrapPageRenderer {
    private BootstrapPageRenderer() {
    }

    @Nonnull
    public static BootstrapBreadcrumb getBreadcrumb(@Nonnull ILayoutExecutionContext iLayoutExecutionContext) {
        BootstrapBreadcrumb bootstrapBreadcrumb = BootstrapBreadcrumbProvider.createBreadcrumb((ILayoutExecutionContext)iLayoutExecutionContext);
        bootstrapBreadcrumb.addClasses(new ICSSClassProvider[]{CBootstrapCSS.D_NONE, CBootstrapCSS.D_SM_BLOCK});
        return bootstrapBreadcrumb;
    }

    @Nonnull
    public static IHCElement<?> getMenuContent(@Nonnull ILayoutExecutionContext iLayoutExecutionContext) {
        IMenuTree iMenuTree = iLayoutExecutionContext.getMenuTree();
        MenuItemDeterminatorCallback menuItemDeterminatorCallback = new MenuItemDeterminatorCallback(iMenuTree, iLayoutExecutionContext.getSelectedMenuItemID());
        return BootstrapMenuItemRenderer.createSideBarMenu(iLayoutExecutionContext, iMenuTree, menuItemDeterminatorCallback);
    }

    @Nonnull
    public static <LEC extends ILayoutExecutionContext, WPEC extends IWebPageExecutionContext> HCNodeList getPageContent(@Nonnull LEC LEC, @Nonnull BiFunction<LEC, IWebPage<WPEC>, WPEC> biFunction) {
        String string;
        IMenuItemPage iMenuItemPage = LEC.getSelectedMenuItem();
        IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse = LEC.getRequestScope();
        IWebPage iWebPage = iMenuItemPage.matchesDisplayFilter() ? (IWebPage)GenericReflection.uncheckedCast((Object)iMenuItemPage.getPage()) : (IWebPage)GenericReflection.uncheckedCast((Object)LEC.getMenuTree().getDefaultMenuItem().getPage());
        HCNodeList hCNodeList = new HCNodeList();
        hCNodeList.addChild((IHCNode)BootstrapSystemMessage.createDefault());
        if ("true".equals(iRequestWebScopeWithoutResponse.params().getAsString((Object)"httpError"))) {
            string = iRequestWebScopeWithoutResponse.params().getAsString((Object)"httpStatusCode");
            String string2 = iRequestWebScopeWithoutResponse.params().getAsString((Object)"httpStatusMessage");
            String string3 = iRequestWebScopeWithoutResponse.params().getAsString((Object)"httpRequestUri");
            hCNodeList.addChild((IHCNode)new BootstrapErrorBox().addChild("HTTP error " + string + " (" + string2 + ")" + (String)(StringHelper.isNotEmpty((String)string3) ? " for request URI " + string3 : "")));
        } else if (iRequestWebScopeWithoutResponse.params().containsKey((Object)"phprga")) {
            hCNodeList.addChild((IHCNode)ForcedRedirectManager.getLastForcedRedirectContent((String)((String)iWebPage.getID())));
        }
        string = (IWebPageExecutionContext)biFunction.apply(LEC, iWebPage);
        hCNodeList.addChild(iWebPage.getHeaderNode((IWebPageExecutionContext)string));
        try {
            iWebPage.getContent((IWebPageExecutionContext)string);
            hCNodeList.addChild((IHCNode)string.getNodeList());
        }
        catch (ForcedRedirectException forcedRedirectException) {
            throw forcedRedirectException;
        }
        catch (Exception exception) {
            new InternalErrorBuilder().setThrowable((Throwable)exception).setRequestScope(iRequestWebScopeWithoutResponse).setDisplayLocale(LEC.getDisplayLocale()).addErrorMessage("html-error-filling-page-content").setUIErrorHandlerFor((IHCNodeWithChildren)hCNodeList).handle();
        }
        return hCNodeList;
    }

    @Nonnull
    public static HCNodeList getPageContent(@Nonnull ILayoutExecutionContext iLayoutExecutionContext) {
        return BootstrapPageRenderer.getPageContent(iLayoutExecutionContext, WebPageExecutionContext::new);
    }

    @Nonnull
    public static HCDiv getMenuAndPageNextToEachOther(@Nonnull ILayoutExecutionContext iLayoutExecutionContext) {
        HCDiv hCDiv = (HCDiv)((HCDiv)new HCDiv().addClass(CBootstrapCSS.D_MD_FLEX)).addClass(CBootstrapCSS.MT_1);
        HCDiv hCDiv2 = (HCDiv)hCDiv.addAndReturnChild((IHCNode)((HCDiv)new HCDiv().addClass(CBootstrapCSS.D_MD_FLEX)));
        HCDiv hCDiv3 = (HCDiv)hCDiv.addAndReturnChild((IHCNode)((HCDiv)((HCDiv)new HCDiv().addClass(CBootstrapCSS.ML_4)).addClass(CBootstrapCSS.FLEX_FILL)));
        ((HCDiv)((HCDiv)hCDiv2.addClass(CBootstrapCSS.D_PRINT_NONE)).addChild((IHCNode)((HCSpan)new HCSpan().setID("menu")).addChild(BootstrapPageRenderer.getMenuContent(iLayoutExecutionContext)))).addChild((IHCNode)new HCDiv().setID("special"));
        hCDiv3.addChild((IHCNode)BootstrapPageRenderer.getPageContent(iLayoutExecutionContext, WebPageExecutionContext::new));
        return hCDiv;
    }
}

